/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.simpleframework.xml.core;

import com.aliyun.odps.simpleframework.xml.core.DefaultScanner;
import com.aliyun.odps.simpleframework.xml.core.Detail;
import com.aliyun.odps.simpleframework.xml.core.ObjectScanner;
import com.aliyun.odps.simpleframework.xml.core.PrimitiveScanner;
import com.aliyun.odps.simpleframework.xml.core.Scanner;
import com.aliyun.odps.simpleframework.xml.core.Support;
import com.aliyun.odps.simpleframework.xml.util.Cache;
import com.aliyun.odps.simpleframework.xml.util.ConcurrentCache;

class ScannerFactory {
    private final Cache<Scanner> cache = new ConcurrentCache<Scanner>();
    private final Support support;

    public ScannerFactory(Support support) {
        this.support = support;
    }

    public Scanner getInstance(Class type) throws Exception {
        Scanner schema = this.cache.fetch(type);
        if (schema == null) {
            Detail detail = this.support.getDetail(type);
            if (this.support.isPrimitive(type)) {
                schema = new PrimitiveScanner(detail);
            } else {
                schema = new ObjectScanner(detail, this.support);
                if (schema.isPrimitive() && !this.support.isContainer(type)) {
                    schema = new DefaultScanner(detail, this.support);
                }
            }
            this.cache.cache(type, schema);
        }
        return schema;
    }
}

