/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.simpleframework.xml.core;

import com.aliyun.odps.simpleframework.xml.Namespace;
import com.aliyun.odps.simpleframework.xml.core.Decorator;
import com.aliyun.odps.simpleframework.xml.stream.NamespaceMap;
import com.aliyun.odps.simpleframework.xml.stream.OutputNode;
import java.util.ArrayList;
import java.util.List;

class NamespaceDecorator
implements Decorator {
    private List<Namespace> scope = new ArrayList<Namespace>();
    private Namespace primary;

    public void set(Namespace namespace) {
        if (namespace != null) {
            this.add(namespace);
        }
        this.primary = namespace;
    }

    public void add(Namespace namespace) {
        this.scope.add(namespace);
    }

    @Override
    public void decorate(OutputNode node) {
        this.decorate(node, null);
    }

    @Override
    public void decorate(OutputNode node, Decorator decorator) {
        if (decorator != null) {
            decorator.decorate(node);
        }
        this.scope(node);
        this.namespace(node);
    }

    private void scope(OutputNode node) {
        NamespaceMap map = node.getNamespaces();
        for (Namespace next : this.scope) {
            String reference = next.reference();
            String prefix = next.prefix();
            map.setReference(reference, prefix);
        }
    }

    private void namespace(OutputNode node) {
        if (this.primary != null) {
            String reference = this.primary.reference();
            node.setReference(reference);
        }
    }
}

