/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.simpleframework.xml.core;

import com.aliyun.odps.simpleframework.xml.core.ArrayInstance;
import com.aliyun.odps.simpleframework.xml.core.Context;
import com.aliyun.odps.simpleframework.xml.core.ElementException;
import com.aliyun.odps.simpleframework.xml.core.Factory;
import com.aliyun.odps.simpleframework.xml.core.Instance;
import com.aliyun.odps.simpleframework.xml.core.InstantiationException;
import com.aliyun.odps.simpleframework.xml.strategy.Type;
import com.aliyun.odps.simpleframework.xml.strategy.Value;
import com.aliyun.odps.simpleframework.xml.stream.InputNode;
import com.aliyun.odps.simpleframework.xml.stream.Position;
import java.lang.reflect.Array;

class ArrayFactory
extends Factory {
    public ArrayFactory(Context context, Type type) {
        super(context, type);
    }

    @Override
    public Object getInstance() throws Exception {
        Class type = this.getComponentType();
        if (type != null) {
            return Array.newInstance(type, 0);
        }
        return null;
    }

    public Instance getInstance(InputNode node) throws Exception {
        Position line = node.getPosition();
        Value value = this.getOverride(node);
        if (value == null) {
            throw new ElementException("Array length required for %s at %s", this.type, line);
        }
        Class type = value.getType();
        return this.getInstance(value, type);
    }

    private Instance getInstance(Value value, Class entry) throws Exception {
        Class expect = this.getComponentType();
        if (!expect.isAssignableFrom(entry)) {
            throw new InstantiationException("Array of type %s cannot hold %s for %s", expect, entry, this.type);
        }
        return new ArrayInstance(value);
    }

    private Class getComponentType() throws Exception {
        Class expect = this.getType();
        if (!expect.isArray()) {
            throw new InstantiationException("The %s not an array for %s", expect, this.type);
        }
        return expect.getComponentType();
    }
}

