/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.security;

import com.aliyun.odps.LazyLoad;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.ElementList;
import com.aliyun.odps.simpleframework.xml.ElementMap;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import java.util.List;
import java.util.Map;

public class User
extends LazyLoad {
    private UserModel model;
    private String project;
    private RestClient client;

    User(UserModel model, String project, RestClient client) {
        this.model = model;
        this.project = project;
        this.client = client;
    }

    @Override
    public void reload() throws OdpsException {
        String resource = ResourceBuilder.buildUserResource(this.project, this.model.id);
        this.model = this.client.request(UserModel.class, resource, "GET");
        this.setLoaded(true);
    }

    public String getID() {
        return this.model.id;
    }

    public String getDisplayname() {
        return this.model.displayName;
    }

    public String getComment() {
        this.lazyLoad();
        return this.model.comment;
    }

    public int getLabel() {
        this.lazyLoad();
        return this.model.label;
    }

    public List<String> getRoles() {
        this.lazyLoad();
        return this.model.roles;
    }

    public Map<String, String> getProperties() {
        this.lazyLoad();
        return this.model.properties;
    }

    @Root(name="User", strict=false)
    static class UserModel {
        @Element(name="ID", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String id;
        @Element(name="DisplayName", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String displayName;
        @Element(name="Comment", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String comment;
        @Element(name="Label", required=false)
        int label;
        @ElementList(name="Roles", entry="Role", required=false)
        List<String> roles;
        @ElementMap(name="Properties", entry="Property", key="key", value="value", required=false)
        Map<String, String> properties;

        UserModel() {
        }
    }
}

