/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.expression;

import com.aliyun.odps.data.GenerateExpression;
import com.aliyun.odps.expression.TruncTime;
import com.aliyun.odps.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;

public class GenerationExpressionParser {
    private static final Gson GSON = new Gson();
    private static final Type EXPRESSION_LIST_TYPE = new TypeToken<List<ExpressionItem>>(){}.getType();

    public static GenerateExpression parse(String exprJson) {
        if (StringUtils.isNullOrEmpty((String)exprJson)) {
            return null;
        }
        List<ExpressionItem> generateExpression = GenerationExpressionParser.parseFromJson(exprJson);
        ExpressionItem topLevelExpression = generateExpression.get(generateExpression.size() - 1);
        FunctionCall functionCall = topLevelExpression.getFunctionCall();
        if (functionCall != null && "trunc_time".equalsIgnoreCase(functionCall.getName())) {
            return new TruncTime(generateExpression.get(0).getLeafExprDesc().getReference().getName(), generateExpression.get(1).getLeafExprDesc().getConstant());
        }
        throw new UnsupportedOperationException("Unknown Expression: " + (functionCall != null ? functionCall.getName() : "null"));
    }

    private static List<ExpressionItem> parseFromJson(String exprJson) {
        return (List)GSON.fromJson(exprJson, EXPRESSION_LIST_TYPE);
    }

    static class FunctionCall {
        private String name;
        private Integer parameterCount;
        private String type;

        FunctionCall() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getParameterCount() {
            return this.parameterCount;
        }

        public void setParameterCount(Integer parameterCount) {
            this.parameterCount = parameterCount;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    public static class LeafExprDesc {
        private Reference reference;
        private String constant;
        private boolean isNull;
        private String type;

        public Reference getReference() {
            return this.reference;
        }

        public void setReference(Reference reference) {
            this.reference = reference;
        }

        public String getConstant() {
            return this.constant;
        }

        public void setConstant(String constant) {
            this.constant = constant;
        }

        public boolean isNull() {
            return this.isNull;
        }

        public void setNull(boolean aNull) {
            this.isNull = aNull;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public static class Reference {
            private String name;

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }
        }
    }

    static class ExpressionItem {
        private LeafExprDesc leafExprDesc;
        private FunctionCall functionCall;

        ExpressionItem() {
        }

        public LeafExprDesc getLeafExprDesc() {
            return this.leafExprDesc;
        }

        public void setLeafExprDesc(LeafExprDesc leafExprDesc) {
            this.leafExprDesc = leafExprDesc;
        }

        public FunctionCall getFunctionCall() {
            return this.functionCall;
        }

        public void setFunctionCall(FunctionCall functionCall) {
            this.functionCall = functionCall;
        }
    }
}

