/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.data.converter;

import com.aliyun.odps.Column;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.data.OdpsTypeTransformer;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.converter.OdpsObjectConverter;
import com.aliyun.odps.data.converter.OdpsRecordConverterBuilder;
import com.aliyun.odps.type.TypeInfo;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class OdpsRecordConverter {
    final String nullFormat;
    final boolean enableNullParse;
    final boolean strictMode;
    Function<Column[], Record> recordProvider;
    Map<OdpsType, OdpsObjectConverter> objectConverterMap;

    OdpsRecordConverter(OdpsRecordConverterBuilder.Config config, Function<Column[], Record> recordProvider, Map<OdpsType, OdpsObjectConverter> objectConverterMap) {
        this.nullFormat = config.nullFormat;
        this.enableNullParse = config.enableNullParse;
        this.strictMode = config.strictMode;
        this.recordProvider = recordProvider;
        this.objectConverterMap = objectConverterMap;
    }

    public static OdpsRecordConverterBuilder builder() {
        return new OdpsRecordConverterBuilder();
    }

    public static OdpsRecordConverter defaultConverter() {
        return OdpsRecordConverter.builder().build();
    }

    public String formatObject(Object object, TypeInfo typeInfo) {
        if (null == object) {
            return this.nullFormat;
        }
        if (this.strictMode) {
            Class expectClass = OdpsTypeTransformer.odpsTypeToJavaType((Map)OdpsTypeTransformer.ODPS_TYPE_MAPPER_V2, (OdpsType)typeInfo.getOdpsType());
            try {
                object = typeInfo.getOdpsType() == OdpsType.STRING && object instanceof byte[] ? new String((byte[])object, StandardCharsets.UTF_8) : expectClass.cast(object);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Cannot format " + object + "(" + object.getClass() + ") to ODPS type: " + typeInfo.getOdpsType() + ", expect java class: " + expectClass.getName(), e);
            }
        }
        return this.objectConverterMap.get(typeInfo.getOdpsType()).format(object, typeInfo, this);
    }

    public String[] formatRecord(Record record) {
        Column[] columns = record.getColumns();
        String[] result = new String[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            TypeInfo typeInfo = columns[i].getTypeInfo();
            result[i] = this.formatObject(record.get(i), typeInfo);
        }
        return result;
    }

    public Iterable<String[]> formatResultSet(Iterable<Record> resultSet) {
        return new OdpsFormatResultSet(resultSet, this);
    }

    public Object parseObject(String str, TypeInfo typeInfo) {
        Objects.requireNonNull(str);
        if (this.enableNullParse && this.nullFormat.equals(str)) {
            return null;
        }
        return this.objectConverterMap.get(typeInfo.getOdpsType()).parse(str, typeInfo, this);
    }

    public Record parseRecord(String[] stringArray, Column[] columns) {
        Record record = this.recordProvider.apply(columns);
        for (int i = 0; i < columns.length; ++i) {
            record.set(i, this.parseObject(stringArray[i], columns[i].getTypeInfo()));
        }
        return record;
    }

    public Iterable<Record> parseResultSet(Iterable<String[]> recordSet, Column[] columns) {
        return new OdpsParseResultSet(recordSet, columns, this);
    }

    static class OdpsParseResultSet
    implements Iterable<Record> {
        private final Iterator<String[]> sourceIterator;
        private final Column[] columns;
        private final OdpsRecordConverter parser;

        OdpsParseResultSet(Iterable<String[]> sourceIterable, Column[] columns, OdpsRecordConverter context) {
            this.sourceIterator = sourceIterable.iterator();
            this.columns = columns;
            this.parser = context;
        }

        @Override
        public Iterator<Record> iterator() {
            return new Itr();
        }

        private class Itr
        implements Iterator<Record> {
            private Itr() {
            }

            @Override
            public boolean hasNext() {
                return OdpsParseResultSet.this.sourceIterator.hasNext();
            }

            @Override
            public Record next() {
                return OdpsParseResultSet.this.parser.parseRecord((String[])OdpsParseResultSet.this.sourceIterator.next(), OdpsParseResultSet.this.columns);
            }
        }
    }

    static class OdpsFormatResultSet
    implements Iterable<String[]> {
        private final Iterator<Record> sourceIterator;
        private final OdpsRecordConverter converter;

        OdpsFormatResultSet(Iterable<Record> sourceIterable, OdpsRecordConverter converter) {
            this.sourceIterator = sourceIterable.iterator();
            this.converter = converter;
        }

        @Override
        public Iterator<String[]> iterator() {
            return new Itr();
        }

        private class Itr
        implements Iterator<String[]> {
            private Itr() {
            }

            @Override
            public boolean hasNext() {
                return OdpsFormatResultSet.this.sourceIterator.hasNext();
            }

            @Override
            public String[] next() {
                return OdpsFormatResultSet.this.converter.formatRecord((Record)OdpsFormatResultSet.this.sourceIterator.next());
            }
        }
    }
}

