/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.data.converter;

import com.aliyun.odps.OdpsType;
import com.aliyun.odps.data.Binary;
import com.aliyun.odps.data.Char;
import com.aliyun.odps.data.SimpleJsonValue;
import com.aliyun.odps.data.Varchar;
import com.aliyun.odps.data.converter.ComplexObjectConverter;
import com.aliyun.odps.data.converter.OdpsObjectConverter;
import com.aliyun.odps.data.converter.OdpsRecordConverter;
import com.aliyun.odps.data.converter.OdpsRecordConverterBuilder;
import com.aliyun.odps.type.DecimalTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.util.Base64;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.codec.binary.Hex;

class ObjectConverterFactory {
    ObjectConverterFactory() {
    }

    static OdpsObjectConverter getFormatter(OdpsType odpsType, OdpsRecordConverterBuilder.Config config) {
        switch (odpsType) {
            case TINYINT: {
                return TinyIntConverter.INSTANCE;
            }
            case SMALLINT: {
                return SmallIntConverter.INSTANCE;
            }
            case INT: {
                return IntConverter.INSTANCE;
            }
            case BIGINT: {
                return BigIntConverter.INSTANCE;
            }
            case CHAR: {
                return config.quoteStrings ? CharConverter.QUOTE_INSTANCE : CharConverter.INSTANCE;
            }
            case VARCHAR: {
                return config.quoteStrings ? VarcharConverter.QUOTE_INSTANCE : VarcharConverter.INSTANCE;
            }
            case STRING: {
                return config.quoteStrings ? StringConverter.QUOTE_INSTANCE : StringConverter.INSTANCE;
            }
            case FLOAT: {
                switch (config.floatingNumberOutputFormat) {
                    case "to_string": {
                        return FloatConverter.TO_STRING;
                    }
                    case "sql_compatible": {
                        return FloatConverter.SQL_COMPATIBLE;
                    }
                }
                throw new IllegalArgumentException("unsupported float format type");
            }
            case JSON: {
                return JsonConverter.INSTANCE;
            }
            case BOOLEAN: {
                return BooleanConverter.INSTANCE;
            }
            case DOUBLE: {
                switch (config.floatingNumberOutputFormat) {
                    case "to_string": {
                        return DoubleConverter.TO_STRING;
                    }
                    case "sql_compatible": {
                        return DoubleConverter.SQL_COMPATIBLE;
                    }
                }
                throw new IllegalArgumentException("unsupported double format type");
            }
            case DECIMAL: {
                switch (config.decimalOutputFormat) {
                    case "non_zero_padding": {
                        return DecimalConverter.NO_PADDING;
                    }
                    case "zero_padding": {
                        return DecimalConverter.PADDING;
                    }
                }
                throw new IllegalArgumentException("unsupported decimal format type");
            }
            case DATE: {
                return new DateConverter(config);
            }
            case DATETIME: {
                return new DatetimeConverter(config);
            }
            case TIMESTAMP: {
                return new TimestampConverter(config);
            }
            case TIMESTAMP_NTZ: {
                return new TimestampNtzConverter(config);
            }
            case BINARY: {
                switch (config.binaryFormat) {
                    case "base64": {
                        return BinaryConverter.BASE64;
                    }
                    case "utf8": {
                        return BinaryConverter.UTF8;
                    }
                    case "quoted_printable": {
                        return BinaryConverter.QUOTED_PRINTABLE;
                    }
                    case "hex": {
                        return BinaryConverter.HEX;
                    }
                    case "sql": {
                        return BinaryConverter.SQL_FORMAT;
                    }
                }
            }
            case ARRAY: 
            case MAP: 
            case STRUCT: {
                switch (config.complexTypeFormat) {
                    case "json": {
                        return ComplexObjectConverter.JSON;
                    }
                    case "json_str": {
                        return ComplexObjectConverter.JSON_ALL_STR;
                    }
                    case "human_readable": {
                        return ComplexObjectConverter.HUMAN_READABLE;
                    }
                }
            }
        }
        throw new IllegalArgumentException("unsupported data type");
    }

    private static DateTimeFormatter getDateTimeFormatter(String pattern, ZoneId zoneId, OdpsType odpsType) {
        try {
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
            if (zoneId != null) {
                dateTimeFormatter = dateTimeFormatter.withZone(zoneId);
            }
            return dateTimeFormatter.withResolverStyle(ResolverStyle.LENIENT);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("DateTime format for " + odpsType + " illegal: " + pattern);
        }
    }

    private static SimpleDateFormat getLegacyDateTimeFormatter(String pattern, ZoneId zoneId, OdpsType odpsType) {
        try {
            pattern = pattern.replace("u", "y");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
            if (zoneId != null) {
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone(zoneId));
            }
            return simpleDateFormat;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("DateTime format for " + odpsType + " illegal: " + pattern);
        }
    }

    private static boolean isNan(String value) {
        return value.equalsIgnoreCase("nan") || value.equalsIgnoreCase("+nan") || value.equalsIgnoreCase("-nan");
    }

    private static boolean isPositiveInfinity(String value) {
        return value.equalsIgnoreCase("infinity") || value.equalsIgnoreCase("+infinity") || value.equalsIgnoreCase("inf") || value.equalsIgnoreCase("+inf");
    }

    static boolean isNegativeInfinity(String value) {
        return value.equalsIgnoreCase("-infinity") || value.equalsIgnoreCase("-inf");
    }

    private static class TimestampNtzConverter
    extends AbstractTimestampFormatter {
        private final boolean useSqlFormat;
        private final ZoneId zoneId;

        TimestampNtzConverter(OdpsRecordConverterBuilder.Config config) {
            String parsePattern;
            this.useSqlFormat = config.useSqlFormat;
            this.zoneId = config.timezone;
            String outputPattern = config.timestampNtzOutputFormat;
            if (outputPattern != null) {
                this.outputFormatter = ObjectConverterFactory.getDateTimeFormatter(outputPattern, ZoneId.of("UTC"), OdpsType.TIMESTAMP_NTZ);
            }
            if ((parsePattern = config.timestampNtzParseFormat) != null) {
                this.parseFormatter = ObjectConverterFactory.getDateTimeFormatter(outputPattern, ZoneId.of("UTC"), OdpsType.TIMESTAMP_NTZ);
            }
        }

        @Override
        public String format(Object object, TypeInfo typeInfo, OdpsRecordConverter converter) {
            String formattedStr;
            if (object instanceof Instant) {
                Instant i = (Instant)object;
                formattedStr = i.atZone(this.zoneId).format(this.outputFormatter);
            } else if (object instanceof Timestamp) {
                Instant i = ((Timestamp)object).toInstant();
                formattedStr = i.atZone(this.zoneId).format(this.outputFormatter);
            } else if (object instanceof LocalDateTime) {
                LocalDateTime localDateTime = (LocalDateTime)object;
                formattedStr = localDateTime.format(this.outputFormatter);
            } else if (object instanceof ZonedDateTime) {
                ZonedDateTime zdt = (ZonedDateTime)object;
                formattedStr = zdt.format(this.outputFormatter);
            } else {
                throw new IllegalArgumentException("Unsupported TIMESTAMP_NTZ object type: " + object.getClass());
            }
            if (this.useSqlFormat) {
                return "TIMESTAMP_NTZ'" + formattedStr + "'";
            }
            return formattedStr;
        }

        @Override
        public Object parse(String str, TypeInfo typeInfo, OdpsRecordConverter converter) {
            return LocalDateTime.parse(str, this.parseFormatter);
        }
    }

    private static class TimestampConverter
    extends AbstractTimestampFormatter {
        private final boolean useSqlFormat;
        private final ZoneId timezone;

        TimestampConverter(OdpsRecordConverterBuilder.Config config) {
            this.useSqlFormat = config.useSqlFormat;
            this.timezone = config.timezone;
            String outputPattern = config.timestampOutputFormat;
            this.outputFormatter = outputPattern != null ? ObjectConverterFactory.getDateTimeFormatter(outputPattern, config.timezone, OdpsType.TIMESTAMP) : this.outputFormatter.withZone(config.timezone);
            String parsePattern = config.timestampParseFormat;
            this.parseFormatter = parsePattern != null ? ObjectConverterFactory.getDateTimeFormatter(parsePattern, config.timezone, OdpsType.TIMESTAMP) : this.parseFormatter.withZone(config.timezone);
        }

        @Override
        public String format(Object object, TypeInfo typeInfo, OdpsRecordConverter converter) {
            String formattedStr;
            if (object instanceof Instant) {
                Instant i = (Instant)object;
                formattedStr = this.outputFormatter.format(i);
            } else if (object instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)object;
                formattedStr = this.outputFormatter.format(timestamp.toInstant().atZone(this.timezone));
            } else if (object instanceof LocalDateTime) {
                LocalDateTime localDateTime = (LocalDateTime)object;
                formattedStr = localDateTime.format(this.outputFormatter);
            } else if (object instanceof ZonedDateTime) {
                ZonedDateTime zdt = (ZonedDateTime)object;
                formattedStr = zdt.format(this.outputFormatter);
            } else {
                throw new IllegalArgumentException("Unsupported TIMESTAMP object type: " + object.getClass());
            }
            if (this.useSqlFormat) {
                return "TIMESTAMP'" + formattedStr + "'";
            }
            return formattedStr;
        }

        @Override
        public Object parse(String str, TypeInfo typeInfo, OdpsRecordConverter converter) {
            return ZonedDateTime.parse(str, this.parseFormatter).toInstant();
        }
    }

    private static abstract class AbstractTimestampFormatter
    implements OdpsObjectConverter {
        DateTimeFormatter outputFormatter = new DateTimeFormatterBuilder().appendPattern("uuuu-MM-dd HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();
        DateTimeFormatter parseFormatter = new DateTimeFormatterBuilder().appendPattern("uuuu-M-d H:m:s").optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter().withResolverStyle(ResolverStyle.LENIENT);

        private AbstractTimestampFormatter() {
        }
    }

    private static class DatetimeConverter
    implements OdpsObjectConverter {
        private static final String DEFAULT_OUTPUT_PATTERN = "uuuu-MM-dd HH:mm:ss";
        private static final String DEFAULT_PARSE_PATTERN = "uuuu-M-d H:m:s";
        private static final DateTimeFormatter DEFAULT_PARSER = new DateTimeFormatterBuilder().appendPattern("uuuu-M-d H:m:s").optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter().withResolverStyle(ResolverStyle.LENIENT);
        private DateTimeFormatter outputFormatter;
        private DateTimeFormatter parseFormatter;
        private SimpleDateFormat legacyOutputFormatter;
        private final boolean strictMode;
        private final boolean useSqlFormat;

        DatetimeConverter(OdpsRecordConverterBuilder.Config config) {
            String parsePattern;
            this.strictMode = config.strictMode;
            this.useSqlFormat = config.useSqlFormat;
            String outputPattern = config.datetimeOutputFormat;
            if (null == outputPattern) {
                outputPattern = DEFAULT_OUTPUT_PATTERN;
            }
            this.parseFormatter = null == (parsePattern = config.datetimeParseFormat) ? DEFAULT_PARSER.withZone(config.timezone) : ObjectConverterFactory.getDateTimeFormatter(parsePattern, config.timezone, OdpsType.DATETIME);
            if (!this.strictMode) {
                this.legacyOutputFormatter = ObjectConverterFactory.getLegacyDateTimeFormatter(outputPattern, config.timezone, OdpsType.DATETIME);
            }
            this.outputFormatter = ObjectConverterFactory.getDateTimeFormatter(outputPattern, config.timezone, OdpsType.DATETIME);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String format(Object object, TypeInfo typeInfo, OdpsRecordConverter converter) {
            String formattedStr;
            if (object instanceof ZonedDateTime) {
                ZonedDateTime zdt = (ZonedDateTime)object;
                formattedStr = zdt.format(this.outputFormatter);
            } else if (object instanceof Date) {
                Date date = (Date)object;
                SimpleDateFormat simpleDateFormat = this.legacyOutputFormatter;
                synchronized (simpleDateFormat) {
                    formattedStr = this.legacyOutputFormatter.format(date);
                }
            } else if (object instanceof LocalDateTime) {
                LocalDateTime localDateTime = (LocalDateTime)object;
                formattedStr = localDateTime.format(this.outputFormatter);
            } else if (object instanceof Instant) {
                Instant instant = (Instant)object;
                formattedStr = instant.atZone(this.outputFormatter.getZone()).format(this.outputFormatter);
            } else {
                throw new IllegalArgumentException("Unsupported DATETIME object type: " + object.getClass());
            }
            if (this.useSqlFormat) {
                return "DATETIME'" + formattedStr + "'";
            }
            return formattedStr;
        }

        @Override
        public Object parse(String str, TypeInfo typeInfo, OdpsRecordConverter converter) {
            ZonedDateTime zdt = ZonedDateTime.parse(str, this.parseFormatter);
            Instant instant = zdt.toInstant();
            instant = instant.minusNanos(instant.getNano() % 1000000);
            return ZonedDateTime.ofInstant(instant, this.parseFormatter.getZone());
        }
    }

    private static class DateConverter
    implements OdpsObjectConverter {
        private static final String DEFAULT_OUTPUT_PATTERN = "uuuu-MM-dd";
        private static final String DEFAULT_PARSE_PATTERN = "uuuu-M-d";
        private DateTimeFormatter outputFormatter;
        private DateTimeFormatter parseFormatter;
        private SimpleDateFormat legacyOutputFormatter;
        private ZoneId zoneId;
        private final boolean strictMode;
        private final boolean useSqlFormat;

        DateConverter(OdpsRecordConverterBuilder.Config config) {
            String parsePattern;
            this.strictMode = config.strictMode;
            this.useSqlFormat = config.useSqlFormat;
            this.zoneId = config.timezone;
            String outputPattern = config.dateOutputFormat;
            if (null == outputPattern) {
                outputPattern = DEFAULT_OUTPUT_PATTERN;
            }
            if (null == (parsePattern = config.dateParseFormat)) {
                parsePattern = DEFAULT_PARSE_PATTERN;
            }
            if (!this.strictMode) {
                this.legacyOutputFormatter = ObjectConverterFactory.getLegacyDateTimeFormatter(outputPattern, config.timezone, OdpsType.DATE);
            }
            this.outputFormatter = ObjectConverterFactory.getDateTimeFormatter(outputPattern, config.timezone, OdpsType.DATE);
            this.parseFormatter = ObjectConverterFactory.getDateTimeFormatter(parsePattern, config.timezone, OdpsType.DATE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String format(Object object, TypeInfo typeInfo, OdpsRecordConverter converter) {
            String formattedStr;
            if (object instanceof LocalDate) {
                LocalDate localDate = (LocalDate)object;
                formattedStr = localDate.format(this.outputFormatter);
            } else if (object instanceof ZonedDateTime) {
                ZonedDateTime zdt = (ZonedDateTime)object;
                formattedStr = zdt.format(this.outputFormatter);
            } else if (object instanceof Date) {
                Date date = (Date)object;
                SimpleDateFormat simpleDateFormat = this.legacyOutputFormatter;
                synchronized (simpleDateFormat) {
                    formattedStr = this.legacyOutputFormatter.format(date);
                }
            } else if (object instanceof LocalDateTime) {
                LocalDateTime localDateTime = (LocalDateTime)object;
                formattedStr = localDateTime.format(this.outputFormatter);
            } else if (object instanceof Instant) {
                Instant instant = (Instant)object;
                formattedStr = instant.atZone(this.zoneId).format(this.outputFormatter);
            } else {
                throw new IllegalArgumentException("Unsupported DATE object type: " + object.getClass());
            }
            if (this.useSqlFormat) {
                return "DATE'" + formattedStr + "'";
            }
            return formattedStr;
        }

        @Override
        public Object parse(String str, TypeInfo typeInfo, OdpsRecordConverter converter) {
            return LocalDate.parse(str, this.parseFormatter);
        }
    }

    private static enum JsonConverter implements OdpsObjectConverter
    {
        INSTANCE;


        @Override
        public String format(Object object, TypeInfo typeInfo, OdpsRecordConverter converter) {
            return object.toString();
        }

        @Override
        public Object parse(String str, TypeInfo typeInfo, OdpsRecordConverter converter) {
            return new SimpleJsonValue(str);
        }
    }

    private static enum BinaryConverter implements OdpsObjectConverter
    {
        BASE64("base64"),
        HEX("hex"),
        SQL_FORMAT("sql"),
        UTF8("utf8"),
        QUOTED_PRINTABLE("quoted_printable");

        private String type;

        private BinaryConverter(String type) {
            this.type = type.toLowerCase();
        }

        @Override
        public String format(Object object, TypeInfo typeInfo, OdpsRecordConverter converter) {
            byte[] bytes;
            if (object instanceof Binary) {
                Binary binary = (Binary)object;
                bytes = binary.data();
            } else if (object instanceof byte[]) {
                bytes = (byte[])object;
            } else {
                throw new IllegalArgumentException("Unsupported BINARY object type: " + object.getClass());
            }
            switch (this.type) {
                case "utf8": {
                    return new String(bytes, StandardCharsets.UTF_8);
                }
                case "base64": {
                    return Base64.getEncoder().encodeToString(bytes);
                }
                case "quoted_printable": {
                    return new Binary(bytes).toString();
                }
                case "hex": {
                    return new String(Hex.encodeHex((byte[])bytes));
                }
                case "sql": {
                    return "X'" + new String(Hex.encodeHex((byte[])bytes)) + "'";
                }
            }
            throw new RuntimeException("Unsupported binary encode type: " + this.type);
        }

        @Override
        public Object parse(String str, TypeInfo typeInfo, OdpsRecordConverter converter) {
            switch (this.type) {
                case "utf8": {
                    return str.getBytes(StandardCharsets.UTF_8);
                }
                case "base64": {
                    return Base64.getDecoder().decode(str);
                }
                case "hex": {
                    try {
                        return Hex.decodeHex((char[])str.toCharArray());
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(String.format("InvalidData: invalid hex string %s", str));
                    }
                }
            }
            throw new IllegalArgumentException();
        }
    }

    private static enum BooleanConverter implements OdpsObjectConverter
    {
        INSTANCE;


        @Override
        public String format(Object object, TypeInfo typeInfo, OdpsRecordConverter converter) {
            return object.toString();
        }

        @Override
        public Object parse(String str, TypeInfo typeInfo, OdpsRecordConverter converter) {
            return Boolean.parseBoolean(str);
        }
    }

    private static enum StringConverter implements OdpsObjectConverter
    {
        INSTANCE(false),
        QUOTE_INSTANCE(true);

        private final boolean quoteStrings;

        private StringConverter(boolean quoteStrings) {
            this.quoteStrings = quoteStrings;
        }

        @Override
        public String format(Object object, TypeInfo typeInfo, OdpsRecordConverter converter) {
            String str = object instanceof byte[] ? new String((byte[])object, StandardCharsets.UTF_8) : (String)object;
            if (this.quoteStrings) {
                String escapedString = str.replace("'", "\\'");
                return "'" + escapedString + "'";
            }
            return str;
        }

        @Override
        public Object parse(String str, TypeInfo typeInfo, OdpsRecordConverter converter) {
            return str;
        }
    }

    private static enum VarcharConverter implements OdpsObjectConverter
    {
        INSTANCE(false),
        QUOTE_INSTANCE(true);

        private final boolean quoteStrings;

        private VarcharConverter(boolean quoteStrings) {
            this.quoteStrings = quoteStrings;
        }

        @Override
        public String format(Object object, TypeInfo typeInfo, OdpsRecordConverter converter) {
            String str = object instanceof byte[] ? new String((byte[])object, StandardCharsets.UTF_8) : object.toString();
            if (this.quoteStrings) {
                String escapedString = str.replace("'", "\\'");
                return "'" + escapedString + "'";
            }
            return str;
        }

        @Override
        public Object parse(String str, TypeInfo typeInfo, OdpsRecordConverter converter) {
            return new Varchar(str);
        }
    }

    private static enum CharConverter implements OdpsObjectConverter
    {
        INSTANCE(false),
        QUOTE_INSTANCE(true);

        private final boolean quoteStrings;

        private CharConverter(boolean quoteStrings) {
            this.quoteStrings = quoteStrings;
        }

        @Override
        public String format(Object object, TypeInfo typeInfo, OdpsRecordConverter converter) {
            String str = object instanceof byte[] ? new String((byte[])object, StandardCharsets.UTF_8) : object.toString();
            if (this.quoteStrings) {
                String escapedString = str.replace("'", "\\'");
                return "'" + escapedString + "'";
            }
            return str;
        }

        @Override
        public Object parse(String str, TypeInfo typeInfo, OdpsRecordConverter converter) {
            return new Char(str);
        }
    }

    private static enum DecimalConverter implements OdpsObjectConverter
    {
        PADDING(true),
        NO_PADDING(false);

        private final boolean padding;

        private DecimalConverter(boolean padding) {
            this.padding = padding;
        }

        @Override
        public String format(Object object, TypeInfo typeInfo, OdpsRecordConverter converter) {
            if (object instanceof BigDecimal) {
                BigDecimal decimal = (BigDecimal)object;
                if (this.padding) {
                    DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)typeInfo;
                    decimal = decimal.setScale(decimalTypeInfo.getScale(), RoundingMode.HALF_DOWN);
                    return decimal.toPlainString();
                }
                return decimal.stripTrailingZeros().toPlainString();
            }
            if (object instanceof Number) {
                return object.toString();
            }
            throw new IllegalArgumentException("Unsupported DECIMAL object type: " + object.getClass());
        }

        @Override
        public Object parse(String str, TypeInfo typeInfo, OdpsRecordConverter converter) {
            int typeIntLength;
            DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)typeInfo;
            BigDecimal bigDecimal = new BigDecimal(str);
            int valueIntLength = bigDecimal.precision() - bigDecimal.scale();
            if (valueIntLength > (typeIntLength = decimalTypeInfo.getPrecision() - decimalTypeInfo.getScale())) {
                throw new IllegalArgumentException(String.format("InvalidData: decimal value %s overflow, max integer digit number is %s.", str, typeIntLength));
            }
            bigDecimal = bigDecimal.setScale(decimalTypeInfo.getScale(), RoundingMode.HALF_DOWN);
            return bigDecimal;
        }
    }

    private static class FloatingNumberFormatter {
        MathContext mathContext;
        DecimalFormat posScientificFormat;
        DecimalFormat negScientificFormat;
        int minFractionDigits;
        int maxFractionDigits;
        boolean appendZero;

        private void setExpSymbol(DecimalFormat format, String symbol) {
            DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
            symbols.setExponentSeparator(symbol);
            format.setDecimalFormatSymbols(symbols);
        }

        FloatingNumberFormatter(int precise, int minFractionDigits, int maxFractionDigits, String scientificFormatPattern, boolean expPlus, boolean appendZero) {
            this.mathContext = new MathContext(precise, RoundingMode.HALF_EVEN);
            this.posScientificFormat = new DecimalFormat(scientificFormatPattern);
            this.setExpSymbol(this.posScientificFormat, "e");
            this.negScientificFormat = new DecimalFormat(scientificFormatPattern);
            this.setExpSymbol(this.negScientificFormat, "e");
            if (expPlus) {
                this.setExpSymbol(this.posScientificFormat, "e+");
            }
            this.minFractionDigits = minFractionDigits;
            this.maxFractionDigits = maxFractionDigits;
            this.appendZero = appendZero;
        }

        private String format(double f) {
            if (!Double.isFinite(f)) {
                return Double.toString(f);
            }
            BigDecimal bigDecimal = new BigDecimal(String.valueOf(f));
            String eStr = String.format("%e", bigDecimal = bigDecimal.round(this.mathContext)).split("e")[1];
            int e = Integer.parseInt(eStr);
            if (e < this.minFractionDigits || e >= this.maxFractionDigits) {
                if (e >= 0) {
                    return this.posScientificFormat.format(bigDecimal);
                }
                return this.negScientificFormat.format(bigDecimal);
            }
            String result = bigDecimal.stripTrailingZeros().toPlainString();
            if (this.appendZero && !result.contains(".")) {
                result = result + ".0";
            }
            return result;
        }
    }

    private static enum FloatConverter implements OdpsObjectConverter
    {
        TO_STRING{

            @Override
            public String format(Object object, TypeInfo typeInfo, OdpsRecordConverter converter) {
                float f = ((Float)object).floatValue();
                return Float.toString(f);
            }
        }
        ,
        SQL_COMPATIBLE{
            private final FloatingNumberFormatter formatter = new FloatingNumberFormatter(7, -4, 7, "#.########E00", true, false);

            @Override
            public String format(Object object, TypeInfo typeInfo, OdpsRecordConverter converter) {
                double f = ((Float)object).floatValue();
                return this.formatter.format(f);
            }
        };


        @Override
        public Object parse(String str, TypeInfo typeInfo, OdpsRecordConverter converter) {
            if (ObjectConverterFactory.isNan(str)) {
                return Float.valueOf(Float.NaN);
            }
            if (ObjectConverterFactory.isPositiveInfinity(str)) {
                return Float.valueOf(Float.POSITIVE_INFINITY);
            }
            if (ObjectConverterFactory.isNegativeInfinity(str)) {
                return Float.valueOf(Float.NEGATIVE_INFINITY);
            }
            return Float.valueOf(Float.parseFloat(str));
        }
    }

    private static enum DoubleConverter implements OdpsObjectConverter
    {
        TO_STRING{

            @Override
            public String format(Object object, TypeInfo typeInfo, OdpsRecordConverter converter) {
                double value = (Double)object;
                return Double.toString(value);
            }
        }
        ,
        SQL_COMPATIBLE{
            private final FloatingNumberFormatter formatter = new FloatingNumberFormatter(17, -6, 20, "#.###################E00", false, true);

            @Override
            public String format(Object object, TypeInfo typeInfo, OdpsRecordConverter converter) {
                double d = (Double)object;
                return this.formatter.format(d);
            }
        };


        @Override
        public Object parse(String str, TypeInfo typeInfo, OdpsRecordConverter converter) {
            if (ObjectConverterFactory.isNan(str)) {
                return Double.NaN;
            }
            if (ObjectConverterFactory.isPositiveInfinity(str)) {
                return Double.POSITIVE_INFINITY;
            }
            if (ObjectConverterFactory.isNegativeInfinity(str)) {
                return Double.NEGATIVE_INFINITY;
            }
            return Double.parseDouble(str);
        }
    }

    private static enum BigIntConverter implements OdpsObjectConverter
    {
        INSTANCE;


        @Override
        public String format(Object object, TypeInfo typeInfo, OdpsRecordConverter converter) {
            return object.toString();
        }

        @Override
        public Object parse(String str, TypeInfo typeInfo, OdpsRecordConverter converter) {
            long longVal = Long.parseLong(str);
            if (Long.MIN_VALUE == longVal) {
                throw new IllegalArgumentException("InvalidData: Bigint out of range.");
            }
            return Long.valueOf(str);
        }
    }

    private static enum IntConverter implements OdpsObjectConverter
    {
        INSTANCE;


        @Override
        public String format(Object object, TypeInfo typeInfo, OdpsRecordConverter converter) {
            return object.toString();
        }

        @Override
        public Object parse(String str, TypeInfo typeInfo, OdpsRecordConverter converter) {
            return Integer.valueOf(str);
        }
    }

    private static enum SmallIntConverter implements OdpsObjectConverter
    {
        INSTANCE;


        @Override
        public String format(Object object, TypeInfo typeInfo, OdpsRecordConverter converter) {
            return object.toString();
        }

        @Override
        public Object parse(String str, TypeInfo typeInfo, OdpsRecordConverter converter) {
            return Short.valueOf(str);
        }
    }

    private static enum TinyIntConverter implements OdpsObjectConverter
    {
        INSTANCE;


        @Override
        public String format(Object object, TypeInfo typeInfo, OdpsRecordConverter converter) {
            return object.toString();
        }

        @Override
        public Object parse(String str, TypeInfo typeInfo, OdpsRecordConverter converter) {
            return Byte.valueOf(str);
        }
    }
}

