/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.commons.util.backoff;

import com.aliyun.odps.commons.util.backoff.BackOffStrategy;

public class ExponentialBackOffStrategy
extends BackOffStrategy {
    private static final int DEFAULT_TIMES = 2;
    private long interval;
    private boolean first = true;

    public ExponentialBackOffStrategy(long initInterval) {
        super(initInterval);
        this.interval = initInterval;
    }

    @Override
    public long next() {
        int times = 2;
        if (this.first) {
            times = 1;
            this.first = false;
        }
        this.interval *= (long)times;
        return this.interval * 1000L;
    }

    @Override
    public void reset() {
        this.interval = this.initInterval;
        this.first = true;
    }
}

