/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.account;

import com.aliyun.auth.credentials.ICredential;
import com.aliyun.auth.credentials.exception.CredentialException;
import com.aliyun.auth.credentials.provider.ICredentialProvider;
import com.aliyun.credentials.models.CredentialModel;
import com.aliyun.credentials.provider.AlibabaCloudCredentialsProvider;
import com.aliyun.odps.account.Account;
import com.aliyun.odps.account.BearerTokenRequestSigner;
import com.aliyun.odps.account.RequestSigner;
import com.aliyun.odps.account.StsRequestSigner;
import com.aliyun.odps.utils.StringUtils;

public class AklessAccount
implements Account {
    private final ProviderType providerType;
    private ICredentialProvider credentialsProvider;
    private AlibabaCloudCredentialsProvider alibabaCloudCredentialsProvider;

    public AklessAccount(ICredentialProvider credentialsProvider) {
        this.providerType = ProviderType.ICredentialProvider;
        this.credentialsProvider = credentialsProvider;
    }

    public AklessAccount(AlibabaCloudCredentialsProvider credentialsProvider) {
        this.providerType = ProviderType.AlibabaCloudCredentialsProvider;
        this.alibabaCloudCredentialsProvider = credentialsProvider;
    }

    @Override
    public Account.AccountProvider getType() {
        return Account.AccountProvider.STS;
    }

    @Override
    public RequestSigner getRequestSigner() {
        try {
            switch (this.providerType) {
                case ICredentialProvider: {
                    ICredential credentials = this.credentialsProvider.getCredentials();
                    return new StsRequestSigner(credentials.accessKeyId(), credentials.accessKeySecret(), credentials.securityToken());
                }
                case AlibabaCloudCredentialsProvider: {
                    CredentialModel alibabaCloudCredentials = this.alibabaCloudCredentialsProvider.getCredentials();
                    if (StringUtils.isNotBlank((String)alibabaCloudCredentials.getBearerToken())) {
                        return new BearerTokenRequestSigner(alibabaCloudCredentials.getBearerToken());
                    }
                    return new StsRequestSigner(alibabaCloudCredentials.getAccessKeyId(), alibabaCloudCredentials.getAccessKeySecret(), alibabaCloudCredentials.getSecurityToken());
                }
            }
            throw new RuntimeException("Unsupported provider type: " + (Object)((Object)this.providerType));
        }
        catch (CredentialException e) {
            throw new RuntimeException(e);
        }
    }

    static enum ProviderType {
        ICredentialProvider,
        AlibabaCloudCredentialsProvider;

    }
}

