/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.security.SecurityManager;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import com.aliyun.odps.utils.GsonObjectBuilder;
import com.aliyun.odps.utils.StringUtils;
import com.google.gson.JsonParser;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;

public class TenantSecurityManager {
    private static final String TENANT_ID_PLACE_HOLDER = "_empty_tenant_";
    private RestClient client;

    TenantSecurityManager(RestClient client) {
        this.client = client;
    }

    public String getTenantRolePolicy(String roleName) throws OdpsException {
        if (StringUtils.isNullOrEmpty((String)roleName)) {
            throw new IllegalArgumentException("Argument 'roleName' cannot be null or empty");
        }
        String resource = ResourceBuilder.buildTenantRoleResource(TENANT_ID_PLACE_HOLDER, roleName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("policy", null);
        Response response = this.client.request(resource, "GET", params, null, null);
        String rawResult = new String(response.getBody(), StandardCharsets.UTF_8);
        JsonParser parser = new JsonParser();
        return parser.parse(rawResult).getAsJsonObject().get("Policy").getAsString();
    }

    public void putTenantRolePolicy(String roleName, String policy) throws OdpsException {
        if (StringUtils.isNullOrEmpty((String)roleName)) {
            throw new IllegalArgumentException("Argument 'roleName' cannot be null or empty");
        }
        if (policy == null) {
            throw new IllegalArgumentException("Argument 'policy' cannot be null");
        }
        String resource = ResourceBuilder.buildTenantRoleResource(TENANT_ID_PLACE_HOLDER, roleName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("policy", null);
        this.client.stringRequest(resource, "PUT", params, null, policy);
    }

    public SecurityManager.AuthorizationQueryInstance run(String query, boolean jsonOutput) throws OdpsException {
        String xmlRequest;
        String resource = ResourceBuilder.buildTenantSecurityManagerResource(TENANT_ID_PLACE_HOLDER);
        AuthorizationQueryRequest request = new AuthorizationQueryRequest(query, jsonOutput);
        try {
            xmlRequest = SimpleXmlUtils.marshal(request);
        }
        catch (Exception e) {
            throw new OdpsException(e.getMessage(), e);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/xml");
        Response response = this.client.stringRequest(resource, "POST", null, headers, xmlRequest);
        try {
            AuthorizationQueryResponse queryResponse = AuthorizationQueryResponse.from(response.getBody());
            if (response.getStatus() == 200) {
                return new SecurityManager.AuthorizationQueryInstance(queryResponse.getResult());
            }
            throw new OdpsException("Async tenant authorization instance is not supported yet.");
        }
        catch (Exception e) {
            throw new OdpsException(e.getMessage(), e);
        }
    }

    private static class AuthorizationQueryResponse {
        @Expose
        @SerializedName(value="Response")
        private String result;

        private AuthorizationQueryResponse() {
        }

        public static AuthorizationQueryResponse from(byte[] body) {
            if (body == null) {
                return null;
            }
            return AuthorizationQueryResponse.fromJson(body);
        }

        private static AuthorizationQueryResponse fromJson(byte[] body) {
            try {
                return (AuthorizationQueryResponse)GsonObjectBuilder.get().fromJson(new String(body, StandardCharsets.UTF_8), AuthorizationQueryResponse.class);
            }
            catch (Exception ignore) {
                return null;
            }
        }

        public String getResult() {
            return this.result;
        }
    }

    @Root(name="Authorization", strict=false)
    private static class AuthorizationQueryRequest {
        @Element(name="Query", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        private String query;
        @Element(name="ResponseInJsonFormat", required=false)
        private boolean responseInJsonFormat;

        public AuthorizationQueryRequest() {
            this.query = "";
            this.responseInJsonFormat = true;
        }

        public AuthorizationQueryRequest(String query, boolean jsonFormat) {
            this.query = query;
            this.responseInJsonFormat = jsonFormat;
        }
    }
}

