/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.LazyLoad;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Tags;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Tag
extends LazyLoad {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(TagModel.class, (Object)new TagModelDeserializer()).create();
    TagModel model;
    Odps odps;
    RestClient client;

    public Tag(Tags.TagBuilder builder) {
        TagModel model = new TagModel();
        model.project = builder.classification.getProject();
        model.classification = builder.classification.getName();
        model.name = builder.name;
        model.attributes = new HashMap<String, String>(builder.attributes);
        model.policy = builder.policy;
        this.model = model;
        this.odps = builder.classification.odps;
        this.client = this.odps.getRestClient();
    }

    Tag(TagModel model, Odps odps) {
        this.model = Objects.requireNonNull(model);
        this.odps = Objects.requireNonNull(odps);
        this.client = odps.getRestClient();
    }

    public String getProject() {
        return this.model.project;
    }

    public String getClassification() {
        return this.model.classification;
    }

    public String getName() {
        return this.model.name;
    }

    public String getOwner() {
        this.lazyLoad();
        return this.model.owner;
    }

    public Date getLastModifiedTime() {
        this.lazyLoad();
        return this.model.lastModifiedTime;
    }

    public Date getCreatedTime() {
        this.lazyLoad();
        return this.model.createdTime;
    }

    public Map<String, String> getAttributes() {
        this.lazyLoad();
        return new HashMap<String, String>(this.model.attributes);
    }

    public void setAttribute(String name, String value) {
        this.lazyLoad();
        this.model.attributes.put(Objects.requireNonNull(name), Objects.requireNonNull(value));
    }

    public void removeAttribute(String name) {
        this.lazyLoad();
        if (!this.model.attributes.containsKey(name)) {
            throw new IllegalArgumentException("Attribute '" + name + "' does not exist");
        }
        this.model.attributesToRemove.add(Objects.requireNonNull(name));
    }

    @Override
    public void reload() throws OdpsException {
        String resource = ResourceBuilder.buildTagResource(this.model.project, this.model.classification, this.model.name);
        Response resp = this.client.request(resource, "GET", null, null, null);
        JsonParser parser = new JsonParser();
        String json = new String(resp.getBody(), StandardCharsets.UTF_8);
        JsonObject jsonObject = parser.parse(json).getAsJsonObject();
        this.model = (TagModel)GSON.fromJson(jsonObject.get("Tag"), TagModel.class);
        this.setLoaded(true);
    }

    public static class TagModel {
        String project;
        String classification;
        String name;
        String owner;
        Date lastModifiedTime;
        Date createdTime;
        Map<String, String> attributes = new HashMap<String, String>();
        List<String> attributesToRemove = new LinkedList<String>();
        String policy;
    }

    static class TagModelDeserializer
    implements JsonDeserializer<TagModel> {
        TagModelDeserializer() {
        }

        public TagModel deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject extendedInfo;
            TagModel model = new TagModel();
            JsonObject tag = json.getAsJsonObject();
            model.project = tag.get("DatabaseName").getAsString();
            model.classification = tag.get("Classification").getAsString();
            model.name = tag.get("Name").getAsString();
            model.createdTime = new Date(tag.get("CreateTime").getAsLong());
            model.lastModifiedTime = new Date(tag.get("UpdateTime").getAsLong());
            model.owner = tag.get("Owner").getAsString();
            if (tag.has("ExtendedInfo") && (extendedInfo = tag.get("ExtendedInfo").getAsJsonObject()).has("Policy")) {
                model.policy = extendedInfo.get("Policy").getAsString();
            }
            model.attributes.clear();
            JsonObject tagValues = tag.get("TagValues").getAsJsonObject();
            for (Map.Entry entry : tagValues.entrySet()) {
                model.attributes.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
            }
            return model;
        }
    }

    static class TagModelSerializer
    implements JsonSerializer<TagModel> {
        TagModelSerializer() {
        }

        public JsonElement serialize(TagModel src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject tag = new JsonObject();
            tag.addProperty("DatabaseName", src.project);
            tag.addProperty("Classification", src.classification);
            tag.addProperty("Name", src.name);
            if (src.policy != null) {
                JsonObject extendedInfo = new JsonObject();
                extendedInfo.addProperty("Policy", src.policy);
                tag.add("ExtendedInfo", (JsonElement)extendedInfo);
            }
            JsonObject tagValues = new JsonObject();
            for (Map.Entry<String, String> entry : src.attributes.entrySet()) {
                tagValues.addProperty(entry.getKey(), entry.getValue());
            }
            tag.add("TagValues", (JsonElement)tagValues);
            if (!src.attributesToRemove.isEmpty()) {
                JsonArray attributesToRemove = new JsonArray();
                for (String attribute : src.attributesToRemove) {
                    attributesToRemove.add((JsonElement)new JsonPrimitive(attribute));
                }
                tag.add("TagKeys", (JsonElement)attributesToRemove);
            }
            return tag;
        }
    }
}

