/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.Column;
import com.aliyun.odps.Instance;
import com.aliyun.odps.LazyLoad;
import com.aliyun.odps.ListIterator;
import com.aliyun.odps.NoSuchObjectException;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Partition;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.ReloadException;
import com.aliyun.odps.Shard;
import com.aliyun.odps.StorageTierInfo;
import com.aliyun.odps.Stream;
import com.aliyun.odps.TableLifecycleConfig;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.Tag;
import com.aliyun.odps.UncheckedOdpsException;
import com.aliyun.odps.data.ArrowStreamRecordReader;
import com.aliyun.odps.data.RecordReader;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.simpleframework.xml.Attribute;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.ElementList;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.Text;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import com.aliyun.odps.simpleframework.xml.convert.Converter;
import com.aliyun.odps.simpleframework.xml.stream.InputNode;
import com.aliyun.odps.simpleframework.xml.stream.OutputNode;
import com.aliyun.odps.table.StreamIdentifier;
import com.aliyun.odps.table.TableIdentifier;
import com.aliyun.odps.task.SQLTask;
import com.aliyun.odps.tunnel.Configuration;
import com.aliyun.odps.tunnel.TableTunnel;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.type.TypeInfoParser;
import com.aliyun.odps.utils.ColumnUtils;
import com.aliyun.odps.utils.CommonUtils;
import com.aliyun.odps.utils.NameSpaceSchemaUtils;
import com.aliyun.odps.utils.StringUtils;
import com.aliyun.odps.utils.TagUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.arrow.vector.ipc.ArrowReader;
import org.apache.arrow.vector.ipc.ArrowStreamReader;
import org.apache.commons.io.IOUtils;

public class Table
extends LazyLoad {
    private TableModel model;
    private TableSchema tableSchema;
    private TagUtils.ObjectTagInfo tableTagInfo;
    private RestClient client;
    private boolean isExtendInfoLoaded;
    private boolean isShardInfoLoaded;
    private Odps odps;

    Table(TableModel model, String project, String schemaName, Odps odps) {
        this.model = model;
        this.model.projectName = project;
        this.model.schemaName = schemaName;
        this.odps = odps;
        this.client = odps.getRestClient();
        this.isExtendInfoLoaded = false;
        this.isShardInfoLoaded = false;
    }

    protected void setIsExtendInfoLoaded(boolean isExtendInfoLoaded) {
        this.isExtendInfoLoaded = isExtendInfoLoaded;
    }

    @Override
    public void reload() throws OdpsException {
        this.odps.projects().get(this.model.projectName).executeIfEpv2(() -> {
            this.tableSchema = this.loadEpv2TableFromJson(this.model.projectName, this.model.schemaName, this.model.name);
            this.setLoaded(true);
            return null;
        }, () -> {
            String resource = ResourceBuilder.buildTableResource(this.model.projectName, this.model.name);
            HashMap<String, String> params = this.initParamsWithSchema();
            this.reload(this.client.request(TableModel.class, resource, "GET", params));
            return null;
        });
    }

    public void reload(TableModel model) throws OdpsException {
        this.model = model;
        if (model.schema != null) {
            this.tableSchema = this.loadSchemaFromJson(((TableModel)model).schema.content);
        }
        this.setLoaded(true);
    }

    private void reloadTagInfo() {
        String resource = ResourceBuilder.buildTableResource(this.model.projectName, this.model.name);
        try {
            this.tableTagInfo = TagUtils.getObjectTagInfo(resource, null, this.client);
        }
        catch (OdpsException e) {
            throw new ReloadException(e);
        }
    }

    public void reloadExtendInfo() {
        TableModel response;
        try {
            HashMap<String, String> params = this.initParamsWithSchema();
            params.put("extended", null);
            String resource = ResourceBuilder.buildTableResource(this.model.projectName, this.model.name);
            response = this.client.request(TableModel.class, resource, "GET", params);
        }
        catch (OdpsException e) {
            throw new ReloadException(e.getMessage(), e);
        }
        this.loadSchemaFromJson(((TableModel)response).schema.content);
    }

    private void lazyLoadExtendInfo() {
        if (!this.isExtendInfoLoaded) {
            try {
                this.odps.projects().get(this.model.projectName).executeIfEpv2(() -> {
                    this.isExtendInfoLoaded = true;
                    return null;
                }, () -> {
                    this.reloadExtendInfo();
                    this.isExtendInfoLoaded = true;
                    return null;
                });
            }
            catch (OdpsException e) {
                throw new UncheckedOdpsException(e);
            }
        }
    }

    public String getName() {
        return this.model.name;
    }

    public String getComment() {
        if (this.model.comment == null) {
            this.lazyLoad();
        }
        return this.model.comment;
    }

    public String getOwner() {
        if (this.model.owner == null) {
            this.lazyLoad();
        }
        return this.model.owner;
    }

    public TableType getType() {
        if (this.model.type == null) {
            this.lazyLoad();
        }
        return this.model.type;
    }

    public Date getCreatedTime() {
        if (this.model.createdTime == null) {
            this.lazyLoad();
        }
        return this.model.createdTime;
    }

    public String getTableLabel() {
        if (this.model.tableLabel == null) {
            this.lazyLoad();
        }
        return this.model.tableLabel;
    }

    public List<String> getTableExtendedLabels() {
        if (this.model.tableExtendedLabels == null) {
            this.lazyLoad();
        }
        return this.model.tableExtendedLabels;
    }

    public String getSchemaVersion() {
        this.reloadExtendInfo();
        return this.model.schemaVersion;
    }

    public StorageTierInfo getStorageTierInfo() {
        if (this.isPartitioned()) {
            throw new UnsupportedOperationException("Partitioned table does not support get storage tier info, use Partition.getStorageTierInfo() instead.");
        }
        if (this.model.storageTierInfo == null) {
            this.reloadExtendInfo();
            this.isExtendInfoLoaded = true;
        }
        return this.model.storageTierInfo;
    }

    public TableLifecycleConfig getTableLifecycleConfig() {
        if (this.model.tableLifecycleConfig == null) {
            this.reloadExtendInfo();
            this.isExtendInfoLoaded = true;
        }
        return this.model.tableLifecycleConfig;
    }

    public List<Tag> getTags() {
        this.reloadTagInfo();
        return TagUtils.getTags(this.tableTagInfo, this.odps);
    }

    public List<Tag> getTags(String columnName) {
        this.reloadTagInfo();
        Objects.requireNonNull(columnName);
        TagUtils.validateTaggingColumn(this.getSchema(), Collections.singletonList(columnName));
        return TagUtils.getTags(this.tableTagInfo, columnName, this.odps);
    }

    public Map<String, Map<String, String>> getSimpleTags() {
        this.reloadTagInfo();
        return TagUtils.getSimpleTags(this.tableTagInfo);
    }

    public Map<String, Map<String, String>> getSimpleTags(String columnName) {
        this.reloadTagInfo();
        Objects.requireNonNull(columnName);
        TagUtils.validateTaggingColumn(this.getSchema(), Collections.singletonList(columnName));
        return TagUtils.getSimpleTags(this.tableTagInfo, columnName);
    }

    public void addTag(Tag tag) throws OdpsException {
        this.addTag(tag, null);
    }

    public void addTag(Tag tag, List<String> columnNames) throws OdpsException {
        TagUtils.ObjectRef objectRef = new TagUtils.ObjectRef(TagUtils.OBJECT_TYPE.TABLE, this.model.projectName, this.model.name, columnNames);
        TagUtils.TagRef tagRef = new TagUtils.TagRef(tag.getClassification(), tag.getName());
        TagUtils.SetObjectTagInput setObjectTagInput = new TagUtils.SetObjectTagInput(TagUtils.OPERATION_TYPE.SET, objectRef, tagRef, null);
        TagUtils.updateTagInternal(setObjectTagInput, null, this.client);
    }

    public void addSimpleTag(String category, String key, String value) throws OdpsException {
        this.addSimpleTag(category, key, value, null);
    }

    public void addSimpleTag(String category, String key, String value, List<String> columnNames) throws OdpsException {
        TagUtils.ObjectRef objectRef = new TagUtils.ObjectRef(TagUtils.OBJECT_TYPE.TABLE, this.model.projectName, this.model.name, columnNames);
        TagUtils.SimpleTag simpleTag = new TagUtils.SimpleTag(category, Collections.singletonMap(key, value));
        TagUtils.SetObjectTagInput setObjectTagInput = new TagUtils.SetObjectTagInput(TagUtils.OPERATION_TYPE.SET, objectRef, null, simpleTag);
        TagUtils.updateTagInternal(setObjectTagInput, null, this.client);
    }

    public void removeTag(Tag tag) throws OdpsException {
        this.removeTag(tag, null);
    }

    public void removeTag(Tag tag, List<String> columnNames) throws OdpsException {
        Objects.requireNonNull(tag);
        TagUtils.validateTaggingColumn(this.getSchema(), columnNames);
        TagUtils.ObjectRef objectRef = new TagUtils.ObjectRef(TagUtils.OBJECT_TYPE.TABLE, this.model.projectName, this.model.name, columnNames);
        TagUtils.TagRef tagRef = new TagUtils.TagRef(tag.getClassification(), tag.getName());
        TagUtils.SetObjectTagInput setObjectTagInput = new TagUtils.SetObjectTagInput(TagUtils.OPERATION_TYPE.UNSET, objectRef, tagRef, null);
        TagUtils.updateTagInternal(setObjectTagInput, null, this.client);
    }

    public void removeSimpleTag(String category, String key, String value) throws OdpsException {
        this.removeSimpleTag(category, key, value, null);
    }

    public void removeSimpleTag(String category, String key, String value, List<String> columnNames) throws OdpsException {
        Objects.requireNonNull(category);
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        TagUtils.validateTaggingColumn(this.getSchema(), columnNames);
        TagUtils.ObjectRef objectRef = new TagUtils.ObjectRef(TagUtils.OBJECT_TYPE.TABLE, this.model.projectName, this.model.name, columnNames);
        TagUtils.SimpleTag simpleTag = new TagUtils.SimpleTag(category, Collections.singletonMap(key, value));
        TagUtils.SetObjectTagInput setObjectTagInput = new TagUtils.SetObjectTagInput(TagUtils.OPERATION_TYPE.UNSET, objectRef, null, simpleTag);
        TagUtils.updateTagInternal(setObjectTagInput, null, this.client);
    }

    public String getTableID() {
        if (this.model.ID == null) {
            this.lazyLoad();
        }
        return this.model.ID;
    }

    public String getCryptoAlgoName() {
        if (this.model.cryptoAlgoName == null) {
            this.lazyLoad();
        }
        return this.model.cryptoAlgoName;
    }

    public String getMaxExtendedLabel() {
        ArrayList<String> extendedLabels = new ArrayList<String>();
        if (this.getTableExtendedLabels() != null) {
            extendedLabels.addAll(this.getTableExtendedLabels());
        }
        for (Column column : this.tableSchema.getColumns()) {
            if (column.getExtendedlabels() == null) continue;
            extendedLabels.addAll(column.getExtendedlabels());
        }
        return Table.calculateMaxLabel(extendedLabels);
    }

    public String getMaxLabel() {
        ArrayList<String> labels = new ArrayList<String>();
        labels.add(this.getTableLabel());
        for (Column column : this.tableSchema.getColumns()) {
            labels.add(column.getCategoryLabel());
        }
        return Table.calculateMaxLabel(labels);
    }

    static String calculateMaxLabel(List<String> labels) {
        int maxLevel = 0;
        int category = 45;
        for (String label : labels) {
            char num;
            if (StringUtils.isNullOrEmpty((String)label) || !Character.isDigit(num = label.charAt(label.length() - 1)) || num - 48 < maxLevel) continue;
            if (num - 48 > maxLevel) {
                maxLevel = num - 48;
                category = 45;
            }
            if (label.length() == 1) {
                category = 76;
                continue;
            }
            for (int i = label.length() - 2; i >= 0; --i) {
                int c = label.charAt(i);
                if (!Character.isLetter((char)c)) continue;
                c = Character.toUpperCase((char)c);
                if (category == 45) {
                    category = c;
                    continue;
                }
                if (category == c) continue;
                category = 76;
            }
        }
        if (category == 45 && maxLevel == 0) {
            return "";
        }
        if (category == 45) {
            category = 76;
        }
        return (char)category + "" + maxLevel;
    }

    public Date getLastMetaModifiedTime() {
        if (this.model.lastMetaModifiedTime == null) {
            this.lazyLoad();
        }
        return this.model.lastMetaModifiedTime;
    }

    public String getProject() {
        return this.model.projectName;
    }

    public String getSchemaName() {
        return this.model.schemaName;
    }

    public boolean isVirtualView() {
        if (this.isLoaded()) {
            return this.model.isVirtualView;
        }
        if (this.model.type != null) {
            return TableType.VIRTUAL_VIEW.equals((Object)this.model.type);
        }
        this.lazyLoad();
        return this.model.isVirtualView;
    }

    public boolean isMaterializedView() {
        this.lazyLoad();
        return TableType.MATERIALIZED_VIEW.equals((Object)this.model.type);
    }

    public boolean isMaterializedViewRewriteEnabled() {
        this.lazyLoad();
        if (!this.isMaterializedView()) {
            throw new IllegalStateException("Not a materialized view");
        }
        return this.model.isMaterializedViewRewriteEnabled;
    }

    public boolean isMaterializedViewOutdated() {
        this.lazyLoadExtendInfo();
        if (!this.isMaterializedView()) {
            throw new IllegalStateException("Not a materialized view");
        }
        return this.model.isMaterializedViewOutdated;
    }

    public boolean isExternalTable() {
        if (this.isLoaded()) {
            return this.model.isExternalTable;
        }
        if (this.model.type != null) {
            return TableType.EXTERNAL_TABLE.equals((Object)this.model.type);
        }
        this.lazyLoad();
        return this.model.isExternalTable;
    }

    public boolean isObjectTable() {
        if (this.isLoaded()) {
            return this.model.isObjectTable;
        }
        if (this.model.type != null) {
            return TableType.OBJECT_TABLE.equals((Object)this.model.type);
        }
        this.lazyLoad();
        return this.model.isObjectTable;
    }

    public String getViewText() {
        if (this.model.viewText == null) {
            this.lazyLoad();
        }
        return this.model.viewText;
    }

    public String getViewExpandedText() {
        if (this.model.viewExpandedText == null) {
            this.lazyLoad();
        }
        return this.model.viewExpandedText;
    }

    public List<ColumnMaskInfo> getColumnMaskInfo() {
        if (this.model.columnMaskInfoList != null) {
            return this.model.columnMaskInfoList;
        }
        if (this.model.tableMaskInfo == null) {
            this.lazyLoad();
        }
        if (StringUtils.isNullOrEmpty((String)this.model.tableMaskInfo)) {
            return null;
        }
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        JsonArray jsonArray = JsonParser.parseString((String)this.model.tableMaskInfo).getAsJsonObject().getAsJsonArray("columnMaskInfoList");
        this.model.columnMaskInfoList = new ArrayList<ColumnMaskInfo>(jsonArray.size());
        for (int i = 0; i < jsonArray.size(); ++i) {
            this.model.columnMaskInfoList.add((ColumnMaskInfo)gson.fromJson(jsonArray.get(i), ColumnMaskInfo.class));
        }
        return this.model.columnMaskInfoList;
    }

    public Date getLastDataModifiedTime() {
        if (this.model.lastModifiedTime == null) {
            this.lazyLoad();
        }
        return this.model.lastModifiedTime;
    }

    public Date getLastDataAccessTime() {
        if (this.model.lastAccessTime == null) {
            this.lazyLoad();
        }
        return this.model.lastAccessTime;
    }

    public long getSize() {
        this.lazyLoad();
        return this.model.size;
    }

    public long getRecordNum() {
        this.lazyLoad();
        return this.model.recordNum;
    }

    public long getLife() {
        this.lazyLoad();
        return this.model.life;
    }

    public long getHubLifecycle() {
        this.lazyLoad();
        return this.model.hubLifecycle;
    }

    public TableSchema getSchema() {
        if (this.tableSchema == null) {
            this.lazyLoad();
        }
        return this.tableSchema;
    }

    public String getJsonSchema() {
        if (this.model.schema == null || ((TableModel)this.model).schema.content == null) {
            this.lazyLoad();
        }
        return this.model.schema == null ? null : ((TableModel)this.model).schema.content;
    }

    public boolean isArchived() {
        this.lazyLoadExtendInfo();
        return this.model.isArchived;
    }

    public boolean isTransactional() {
        this.lazyLoadExtendInfo();
        return this.model.isTransactional;
    }

    public long getPhysicalSize() {
        this.lazyLoadExtendInfo();
        return this.model.physicalSize;
    }

    public long getFileNum() {
        this.lazyLoadExtendInfo();
        return this.model.fileNum;
    }

    public String getLocation() {
        if (this.model.location == null) {
            this.lazyLoadExtendInfo();
        }
        return this.model.location;
    }

    public String getStorageHandler() {
        if (this.model.storageHandler == null) {
            this.lazyLoadExtendInfo();
        }
        return this.model.storageHandler;
    }

    public String getResources() {
        if (this.model.resources == null) {
            this.lazyLoadExtendInfo();
        }
        return this.model.resources;
    }

    public Map<String, String> getSerDeProperties() {
        if (this.model.serDeProperties == null) {
            this.lazyLoadExtendInfo();
        }
        return this.model.serDeProperties;
    }

    public String getReserved() {
        if (this.model.reserved == null) {
            this.lazyLoadExtendInfo();
        }
        return this.model.reserved;
    }

    public ClusterInfo getClusterInfo() {
        if (this.model.clusterInfo == null) {
            this.lazyLoadExtendInfo();
        }
        return this.model.clusterInfo;
    }

    public Shard getShard() {
        if (this.model.shard == null) {
            this.lazyLoad();
        }
        return this.model.shard;
    }

    public Date getLastMajorCompactTime() {
        if (this.model.lastMajorCompactTime == null) {
            this.lazyLoadExtendInfo();
        }
        return this.model.lastMajorCompactTime;
    }

    public RecordReader read(int limit) throws OdpsException {
        return this.read(null, null, limit);
    }

    public RecordReader read(PartitionSpec partition, List<String> columns, int limit) throws OdpsException {
        return this.read(partition, columns, limit, null);
    }

    public RecordReader read(PartitionSpec partition, List<String> columns, int limit, String timezone) throws OdpsException {
        return this.read(partition, columns, limit, timezone, false);
    }

    public RecordReader read(PartitionSpec partition, List<String> columns, int limit, String timezone, boolean useLegacyMode) throws OdpsException {
        return this.read(partition, columns, limit, timezone, useLegacyMode, null);
    }

    public RecordReader read(PartitionSpec partition, List<String> columns, int limit, String timezone, boolean useLegacyMode, String tunnelEndpoint) throws OdpsException {
        if (limit <= 0) {
            throw new OdpsException("ODPS-0420061: Invalid parameter in HTTP request - 'linenum' must be bigger than zero!");
        }
        TableSchema schema = this.getSchema();
        int readTimeout = this.odps.getRestClient().getReadTimeout();
        int connectTimeout = this.odps.getRestClient().getConnectTimeout();
        int socketRetryTimes = this.odps.getRestClient().getRetryTimes();
        Configuration tunnelConfig = new Configuration(this.odps);
        tunnelConfig.setSocketTimeout(readTimeout);
        tunnelConfig.setSocketConnectTimeout(connectTimeout);
        tunnelConfig.setSocketRetryTimes(socketRetryTimes);
        TableTunnel tableTunnel = new TableTunnel(this.odps, tunnelConfig);
        if (!StringUtils.isNullOrEmpty((String)tunnelEndpoint)) {
            tableTunnel.setEndpoint(tunnelEndpoint);
        }
        String partitionName = null;
        if (partition != null && !partition.keys().isEmpty()) {
            partitionName = partition.toString().replace("'", "");
        }
        ArrowStreamReader arrowReader = tableTunnel.preview(this.getProject(), this.getSchemaName(), this.model.name, partitionName, Long.valueOf(limit));
        ArrowStreamRecordReader recordReader = new ArrowStreamRecordReader((ArrowReader)arrowReader, schema, columns);
        if (!StringUtils.isNullOrEmpty((String)timezone)) {
            try {
                recordReader.setTimeZone(ZoneId.of(timezone));
            }
            catch (Exception e) {
                throw new OdpsException("invalid timezone name: " + timezone, e);
            }
        }
        try {
            String defaultTimezone = this.odps.projects().get(this.getProject()).getProperty("odps.sql.timezone");
            recordReader.setTimeZone(ZoneId.of(defaultTimezone));
        }
        catch (Exception exception) {
            // empty catch block
        }
        recordReader.setUseLegacyOutputFormat(useLegacyMode);
        return recordReader;
    }

    private TableSchema loadSchemaFromJson(String json) {
        TableSchema s;
        block43: {
            s = new TableSchema();
            try {
                JsonArray tableExtendedLabels;
                Iterator n;
                int i;
                JsonObject tree = new JsonParser().parse(json).getAsJsonObject();
                if (tree.has("comment")) {
                    this.model.comment = tree.get("comment").getAsString();
                }
                if (tree.has("owner")) {
                    this.model.owner = tree.get("owner").getAsString();
                }
                if (tree.has("createTime")) {
                    this.model.createdTime = new Date(tree.get("createTime").getAsLong() * 1000L);
                }
                if (tree.has("lastModifiedTime")) {
                    this.model.lastModifiedTime = new Date(tree.get("lastModifiedTime").getAsLong() * 1000L);
                }
                if (tree.has("lastDDLTime")) {
                    this.model.lastMetaModifiedTime = new Date(tree.get("lastDDLTime").getAsLong() * 1000L);
                }
                if (tree.has("lastAccessTime")) {
                    long timestamp = tree.get("lastAccessTime").getAsLong() * 1000L;
                    Date date = this.model.lastAccessTime = timestamp == 0L ? null : new Date(timestamp);
                }
                if (tree.has("isVirtualView")) {
                    this.model.isVirtualView = tree.get("isVirtualView").getAsBoolean();
                }
                if (tree.has("isMaterializedView") && tree.get("isMaterializedView").getAsBoolean()) {
                    this.model.type = TableType.MATERIALIZED_VIEW;
                }
                if (tree.has("isMaterializedViewRewriteEnabled")) {
                    this.model.isMaterializedViewRewriteEnabled = tree.get("isMaterializedViewRewriteEnabled").getAsBoolean();
                }
                if (tree.has("IsMaterializedViewOutdated")) {
                    this.model.isMaterializedViewOutdated = tree.get("IsMaterializedViewOutdated").getAsBoolean();
                }
                if (tree.has("isExternal")) {
                    this.model.isExternalTable = tree.get("isExternal").getAsBoolean();
                }
                if (tree.has("isObjectTable")) {
                    this.model.isObjectTable = tree.get("isObjectTable").getAsBoolean();
                }
                if (tree.has("lifecycle")) {
                    this.model.life = tree.get("lifecycle").getAsLong();
                }
                if (tree.has("hubLifecycle")) {
                    this.model.hubLifecycle = tree.get("hubLifecycle").getAsLong();
                }
                if (tree.has("viewText")) {
                    this.model.viewText = tree.get("viewText").getAsString();
                }
                if (tree.has("viewExpandedText")) {
                    this.model.viewExpandedText = tree.get("viewExpandedText").getAsString();
                }
                if (tree.has("size")) {
                    this.model.size = tree.get("size").getAsLong();
                }
                if (tree.has("IsArchived")) {
                    this.model.isArchived = tree.get("IsArchived").getAsBoolean();
                }
                if (tree.has("PhysicalSize")) {
                    this.model.physicalSize = tree.get("PhysicalSize").getAsLong();
                }
                if (tree.has("FileNum")) {
                    this.model.fileNum = tree.get("FileNum").getAsLong();
                }
                if (tree.has("recordNum")) {
                    this.model.recordNum = tree.get("recordNum").getAsLong();
                }
                if (tree.has("storageHandler")) {
                    this.model.storageHandler = tree.get("storageHandler").getAsString();
                }
                if (tree.has("location")) {
                    this.model.location = tree.get("location").getAsString();
                }
                if (tree.has("resources")) {
                    this.model.resources = tree.get("resources").getAsString();
                }
                if (tree.has("serDeProperties")) {
                    this.model.serDeProperties = (Map)new GsonBuilder().disableHtmlEscaping().create().fromJson(tree.get("serDeProperties").getAsString(), new TypeToken<Map<String, String>>(){}.getType());
                }
                if (tree.has("shardExist")) {
                    boolean shardExist = tree.get("shardExist").getAsBoolean();
                    this.model.shard = shardExist && tree.has("shardInfo") ? Shard.parseShard(tree.get("shardInfo").getAsJsonObject()) : null;
                }
                if (tree.has("tableLabel")) {
                    this.model.tableLabel = tree.get("tableLabel").getAsString();
                    if (this.model.tableLabel.equals("0")) {
                        this.model.tableLabel = "";
                    }
                }
                if (tree.has("columns") && tree.get("columns") != null) {
                    JsonArray columnsNode = tree.get("columns").getAsJsonArray();
                    for (i = 0; i < columnsNode.size(); ++i) {
                        n = columnsNode.get(i).getAsJsonObject();
                        s.addColumn(ColumnUtils.fromJson(n.toString()));
                    }
                }
                if (tree.has("extendedLabel") && (tableExtendedLabels = tree.get("extendedLabel").getAsJsonArray()).size() != 0) {
                    LinkedList<String> labelList = new LinkedList<String>();
                    for (JsonElement label : tableExtendedLabels) {
                        labelList.add(label.getAsString());
                    }
                    this.model.tableExtendedLabels = labelList;
                }
                if (tree.has("partitionKeys") && tree.get("partitionKeys") != null) {
                    JsonArray columnsNode = tree.get("partitionKeys").getAsJsonArray();
                    for (i = 0; i < columnsNode.size(); ++i) {
                        n = columnsNode.get(i).getAsJsonObject();
                        s.addPartitionColumn(ColumnUtils.fromJson(n.toString()));
                    }
                }
                if (tree.has("Reserved")) {
                    this.model.reserved = tree.get("Reserved").getAsString();
                    this.loadReservedJson(this.model.reserved);
                }
                if (tree.has("props") && tree.get("props") != null) {
                    JsonObject props = tree.get("props").getAsJsonObject();
                    this.model.mvProperties = new HashMap<String, String>();
                    this.model.mvProperties.put("enable_auto_refresh", props.has("enable_auto_refresh") ? props.get("enable_auto_refresh").getAsString() : "false");
                    if (props.has("refresh_interval_minutes")) {
                        this.model.mvProperties.put("refresh_interval_minutes", props.get("refresh_interval_minutes").getAsString());
                    }
                    if (props.has("refresh_cron")) {
                        this.model.mvProperties.put("refresh_cron", props.get("refresh_cron").getAsString());
                    }
                    if (props.has("enable_auto_substitute")) {
                        this.model.mvProperties.put("enable_auto_substitute", props.get("enable_auto_substitute").getAsString());
                    }
                }
                if (!tree.has("RefreshHistory")) break block43;
                String refreshHistoryStr = tree.get("RefreshHistory").getAsString();
                JsonArray refreshHistoryList = new JsonParser().parse(refreshHistoryStr).getAsJsonArray();
                this.model.refreshHistory = new LinkedList<Map<String, String>>();
                for (int i2 = 0; i2 < refreshHistoryList.size(); ++i2) {
                    JsonObject info = refreshHistoryList.get(i2).getAsJsonObject();
                    HashMap<String, String> infoMap = new HashMap<String, String>();
                    infoMap.put("InstanceId", info.has("InstanceId") ? info.get("InstanceId").getAsString() : null);
                    infoMap.put("Status", info.has("Status") ? info.get("Status").getAsString() : null);
                    infoMap.put("StartTime", info.has("StartTime") ? info.get("StartTime").getAsString() : null);
                    infoMap.put("EndTime", info.has("EndTime") ? info.get("EndTime").getAsString() : null);
                    this.model.refreshHistory.add(infoMap);
                    if (this.model.refreshHistory.size() < 10) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableSchema loadEpv2TableFromJson(String projectName, String schemaName, String tableName) throws OdpsException {
        String comment;
        String typeString;
        String name;
        JsonObject node;
        JsonObject n;
        JsonParser parser;
        int i;
        JsonArray columnsNode;
        InputStream is = null;
        HashMap<String, String> queryHint = new HashMap<String, String>();
        try {
            is = Table.class.getResourceAsStream("/com/aliyun/odps/core/base.conf");
            Properties properties = new Properties();
            properties.load(is);
            String majorVersion = properties.getProperty("epv2flighting");
            if (majorVersion != null && !majorVersion.isEmpty() && !"default".equals(majorVersion)) {
                queryHint.put("odps.task.major.version", majorVersion);
            }
        }
        catch (Exception properties) {
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        String jsonString = "";
        queryHint.put("odps.namespace.schema", "true");
        queryHint.put("odps.sql.allow.namespace.schema", "true");
        queryHint.put("odps.default.schema", schemaName);
        queryHint.put("odps.sql.select.output.format", "json");
        Instance instance = SQLTask.run(this.odps, projectName, "desc extended " + tableName + ";", queryHint, null);
        instance.waitForSuccess();
        Instance.InstanceResultModel.TaskResult taskResult = instance.getRawTaskResults().get(0);
        jsonString = taskResult.result.getString();
        TableSchema tableSchema = new TableSchema();
        JsonObject tree = new JsonParser().parse(jsonString).getAsJsonObject();
        if (tree.has("Owner") && !tree.get("Owner").isJsonNull()) {
            this.model.owner = tree.get("Owner").getAsString();
        }
        if (tree.has("Project") && !tree.get("Project").isJsonNull()) {
            this.model.projectName = tree.get("Project").getAsString();
        }
        if (tree.has("Schema") && !tree.get("Schema").isJsonNull()) {
            this.model.schemaName = tree.get("Schema").getAsString();
        }
        if (tree.has("TableComment") && !tree.get("TableComment").isJsonNull()) {
            this.model.comment = tree.get("TableComment").getAsString();
        }
        if (tree.has("CreateTime") && !tree.get("CreateTime").isJsonNull()) {
            this.model.createdTime = new Date(tree.get("CreateTime").getAsLong() * 1000L);
        }
        if (tree.has("LastModifiedTime") && !tree.get("LastModifiedTime").isJsonNull()) {
            this.model.lastModifiedTime = new Date(tree.get("LastModifiedTime").getAsLong() * 1000L);
        }
        if (tree.has("ExternalTable") && !tree.get("ExternalTable").isJsonNull()) {
            this.model.type = TableType.EXTERNAL_TABLE;
            this.model.isExternalTable = "YES".equalsIgnoreCase(tree.get("ExternalTable").getAsString());
        }
        if (tree.has("Size") && !tree.get("Size").isJsonNull()) {
            this.model.size = tree.get("Size").getAsLong();
        }
        if (tree.has("NativeColumns") && !tree.get("NativeColumns").isJsonNull()) {
            columnsNode = tree.get("NativeColumns").getAsJsonArray();
            for (i = 0; i < columnsNode.size(); ++i) {
                parser = new JsonParser();
                n = columnsNode.get(i).getAsJsonObject();
                node = parser.parse(n.toString()).getAsJsonObject();
                name = "";
                typeString = "";
                comment = "";
                String nullable = "";
                String defaultValue = "";
                TypeInfo typeInfo = null;
                if (node.has("Name") && !node.get("Name").isJsonNull()) {
                    name = node.get("Name").getAsString();
                }
                if (node.has("Type") && !node.get("Type").isJsonNull()) {
                    typeString = node.get("Type").getAsString();
                    typeInfo = TypeInfoParser.getTypeInfoFromTypeString((String)typeString);
                }
                if (node.has("Comment") && !node.get("Comment").isJsonNull()) {
                    comment = node.get("Comment").getAsString();
                }
                if (node.has("Nullable") && !node.get("Nullable").isJsonNull()) {
                    nullable = node.get("Nullable").getAsString();
                }
                if (node.has("DefaultValue") && !node.get("DefaultValue").isJsonNull()) {
                    defaultValue = node.get("DefaultValue").getAsString();
                }
                Column column = new Column(name, typeInfo, comment);
                column.setNullable(nullable.equals("true"));
                column.setDefaultValue(defaultValue);
                tableSchema.addColumn(column);
            }
        }
        if (tree.has("PartitionColumns") && !tree.get("PartitionColumns").isJsonNull()) {
            columnsNode = tree.get("PartitionColumns").getAsJsonArray();
            for (i = 0; i < columnsNode.size(); ++i) {
                parser = new JsonParser();
                n = columnsNode.get(i).getAsJsonObject();
                node = parser.parse(n.toString()).getAsJsonObject();
                name = "";
                typeString = "";
                comment = "";
                TypeInfo typeInfo = null;
                if (node.has("Name") && !node.get("Name").isJsonNull()) {
                    name = node.get("Name").getAsString();
                }
                if (node.has("Type") && !node.get("Type").isJsonNull()) {
                    typeString = node.get("Type").getAsString();
                    typeInfo = TypeInfoParser.getTypeInfoFromTypeString((String)typeString);
                }
                if (node.has("Comment") && !node.get("Comment").isJsonNull()) {
                    comment = node.get("Type").getAsString();
                }
                Column column = new Column(name, typeInfo, comment);
                tableSchema.addPartitionColumn(column);
            }
        }
        return tableSchema;
    }

    private void loadReservedJson(String reserved) {
        JsonObject reservedJson = new JsonParser().parse(reserved).getAsJsonObject();
        this.model.clusterInfo = Table.parseClusterInfo(reservedJson);
        this.model.isTransactional = Table.parseTransactionalInfo(reservedJson);
        boolean bl = this.model.hasRowAccessPolicy = reservedJson.has("HasRowAccessPolicy") ? reservedJson.get("HasRowAccessPolicy").getAsBoolean() : false;
        if (reservedJson.has("PrimaryKey")) {
            this.model.primaryKey = new ArrayList<String>();
            JsonArray element = reservedJson.get("PrimaryKey").getAsJsonArray();
            for (JsonElement e : element) {
                this.model.primaryKey.add(e.getAsString());
            }
        }
        this.model.acidDataRetainHours = reservedJson.has("acid.data.retain.hours") ? Integer.parseInt(reservedJson.get("acid.data.retain.hours").getAsString()) : -1;
        this.model.cdcSize = reservedJson.has("cdc_size") ? Long.parseLong(reservedJson.get("cdc_size").getAsString()) : -1L;
        this.model.cdcRecordNum = reservedJson.has("cdc_record_num") ? Long.parseLong(reservedJson.get("cdc_record_num").getAsString()) : -1L;
        long l = this.model.cdcLatestVersion = reservedJson.has("cdc_latest_version") ? Long.parseLong(reservedJson.get("cdc_latest_version").getAsString()) : -1L;
        if (reservedJson.has("cdc_latest_timestamp")) {
            long ts = Long.parseLong(reservedJson.get("cdc_latest_timestamp").getAsString()) * 1000L;
            this.model.cdcLatestTimestamp = new Date(ts);
        }
        this.model.storageTierInfo = StorageTierInfo.getStorageTierInfo(reservedJson);
        this.model.tableLifecycleConfig = TableLifecycleConfig.parse(reservedJson);
        this.model.lastMajorCompactTime = reservedJson.has("LastMajorCompactionTime") ? Date.from(Instant.ofEpochMilli(Long.parseLong(reservedJson.get("LastMajorCompactionTime").getAsString()) * 1000L)) : null;
        this.model.schemaVersion = reservedJson.has("schema_version") ? reservedJson.get("schema_version").getAsString() : null;
    }

    private static boolean parseTransactionalInfo(JsonObject jsonObject) {
        if (!jsonObject.has("Transactional")) {
            return false;
        }
        return Boolean.parseBoolean(jsonObject.get("Transactional").getAsString());
    }

    public static ClusterInfo parseClusterInfo(JsonObject jsonObject) {
        int i;
        JsonArray array;
        if (!jsonObject.has("ClusterType")) {
            return null;
        }
        ClusterInfo clusterInfo = new ClusterInfo();
        clusterInfo.clusterType = jsonObject.has("ClusterType") ? ClusterInfo.ClusterType.valueOf(jsonObject.get("ClusterType").getAsString().toUpperCase()) : null;
        clusterInfo.bucketNum = jsonObject.has("BucketNum") ? jsonObject.get("BucketNum").getAsLong() : 0L;
        JsonArray jsonArray = array = jsonObject.has("ClusterCols") ? jsonObject.get("ClusterCols").getAsJsonArray() : null;
        if (array != null) {
            clusterInfo.clusterCols = new ArrayList<String>();
            for (i = 0; i < array.size(); ++i) {
                clusterInfo.clusterCols.add(array.get(i).getAsString());
            }
        }
        if (jsonObject.has("SortCols")) {
            array = jsonObject.get("SortCols").getAsJsonArray();
            clusterInfo.sortCols = new ArrayList<SortColumn>();
            for (i = 0; i < array.size(); ++i) {
                JsonObject obj = array.get(i).getAsJsonObject();
                if (obj == null) continue;
                clusterInfo.sortCols.add(new SortColumn(obj.get("col").getAsString(), obj.get("order").getAsString()));
            }
        }
        return clusterInfo;
    }

    public void createPartition(PartitionSpec spec) throws OdpsException {
        this.createPartition(spec, false);
    }

    public void createPartition(PartitionSpec spec, boolean ifNotExists) throws OdpsException {
        StringBuilder sb = new StringBuilder();
        sb.append("ALTER TABLE ").append(this.getCoordinate());
        sb.append(" ADD");
        if (ifNotExists) {
            sb.append(" IF NOT EXISTS");
        }
        sb.append(" PARTITION (");
        String[] keys = spec.keys().toArray(new String[0]);
        for (int i = 0; i < keys.length; ++i) {
            sb.append(keys[i]).append("='").append(spec.get(keys[i])).append("'");
            if (i + 1 >= keys.length) continue;
            sb.append(',');
        }
        sb.append(");");
        String taskName = "SQLAddPartitionTask";
        this.runSQL(taskName, sb.toString());
    }

    public void deletePartition(PartitionSpec spec) throws OdpsException {
        this.deletePartition(spec, false);
    }

    public void deletePartition(PartitionSpec spec, boolean ifExists) throws OdpsException {
        StringBuilder sb = new StringBuilder();
        sb.append("ALTER TABLE ").append(this.getCoordinate());
        sb.append(" DROP");
        if (ifExists) {
            sb.append(" IF EXISTS");
        }
        sb.append(" PARTITION(");
        String[] keys = spec.keys().toArray(new String[0]);
        for (int i = 0; i < keys.length; ++i) {
            sb.append(keys[i]).append("='").append(spec.get(keys[i])).append("'");
            if (i + 1 >= keys.length) continue;
            sb.append(',');
        }
        sb.append(");");
        String taskName = "SQLDropPartitionTask";
        this.runSQL(taskName, sb.toString());
    }

    public List<PartitionSpec> getPartitionSpecs() throws OdpsException {
        HashMap<String, String> params = this.initParamsWithSchema();
        params.put("partitions", null);
        params.put("name", null);
        String resource = ResourceBuilder.buildTableResource(this.model.projectName, this.model.name);
        ArrayList<PartitionSpec> partitionSpecs = new ArrayList<PartitionSpec>();
        ListPartitionSpecsResponse resp = this.client.request(ListPartitionSpecsResponse.class, resource, "GET", params);
        for (Partition.PartitionSpecModel partitionSpecModel : resp.partitionSpecs) {
            partitionSpecs.add(new PartitionSpec(partitionSpecModel.partitionSpec, false));
        }
        return partitionSpecs;
    }

    public void createShards(long shardCount) throws OdpsException {
        StringBuilder sb = new StringBuilder();
        sb.append("ALTER TABLE ").append(this.getCoordinate());
        sb.append(String.format(" INTO %d SHARDS;", shardCount));
        String taskName = "SQLCreateShardsTask";
        this.runSQL(taskName, sb.toString());
    }

    public Iterator<Partition> getPartitionIterator() {
        return this.getPartitionIterator(null);
    }

    public Iterator<Partition> getPartitionIterator(PartitionSpec spec) {
        return this.getPartitionIterator(spec, false, 1000L, Long.MAX_VALUE);
    }

    public Iterator<Partition> getPartitionIterator(final PartitionSpec spec, final boolean reverse, final Long batchSize, Long limit) {
        if (limit != null && limit <= 0L) {
            throw new IllegalArgumentException("Argument 'limit' should be greater than 0");
        }
        if (batchSize != null && batchSize <= 0L) {
            throw new IllegalArgumentException("Argument 'batchSize' should be greater than 0");
        }
        final long finalLimit = limit == null ? Long.MAX_VALUE : limit;
        return new ListIterator<Partition>(){
            long numPartitions = 0L;
            Map<String, String> params = new HashMap<String, String>();

            @Override
            public boolean hasNext() {
                return super.hasNext() && this.numPartitions < finalLimit;
            }

            @Override
            public Partition next() {
                Partition partition = (Partition)super.next();
                ++this.numPartitions;
                return partition;
            }

            @Override
            public String getMarker() {
                return this.params.get("marker");
            }

            @Override
            public List<Partition> list(String marker, long maxItems) {
                if (marker != null) {
                    this.params.put("marker", marker);
                }
                if (maxItems >= 0L) {
                    this.params.put("maxitems", String.valueOf(maxItems));
                }
                return this.list();
            }

            @Override
            protected List<Partition> list() {
                ArrayList<Partition> partitions = new ArrayList<Partition>();
                this.params.put("partitions", null);
                this.params.put("expectmarker", "true");
                if (spec != null && !spec.isEmpty()) {
                    this.params.put("partition", spec.toString());
                }
                if (reverse) {
                    this.params.put("reverse", null);
                }
                if (this.params.get("maxitems") == null && batchSize != null) {
                    this.params.put("maxitems", batchSize.toString());
                }
                String lastMarker = this.params.get("marker");
                if (this.params.containsKey("marker") && lastMarker.length() == 0) {
                    return null;
                }
                String resource = ResourceBuilder.buildTableResource(((Table)Table.this).model.projectName, ((Table)Table.this).model.name);
                try {
                    this.params.putAll(Table.this.initParamsWithSchema());
                    ListPartitionsResponse resp = Table.this.client.request(ListPartitionsResponse.class, resource, "GET", this.params);
                    for (Partition.PartitionModel partitionModel : resp.partitions) {
                        Partition t = new Partition(partitionModel, ((Table)Table.this).model.projectName, ((Table)Table.this).model.schemaName, ((Table)Table.this).model.name, Table.this.odps);
                        partitions.add(t);
                    }
                    this.params.put("marker", resp.marker);
                }
                catch (OdpsException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                return partitions;
            }
        };
    }

    public List<Partition> getPartitions() {
        ArrayList<Partition> parts = new ArrayList<Partition>();
        Iterator<Partition> it = this.getPartitionIterator();
        while (it.hasNext()) {
            parts.add(it.next());
        }
        return parts;
    }

    public Partition getPartition(PartitionSpec spec) {
        return new Partition(spec, this.model.projectName, this.model.schemaName, this.model.name, this.odps);
    }

    public boolean hasPartition(PartitionSpec spec) throws OdpsException {
        try {
            Partition part = this.getPartition(spec);
            part.reload();
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        return true;
    }

    public void truncate() throws OdpsException {
        StringBuilder sb = new StringBuilder();
        sb.append("TRUNCATE TABLE ").append(this.getCoordinate()).append(";");
        String taskName = "SQLTruncateTask";
        this.runSQL(taskName, sb.toString());
    }

    public boolean isPartitioned() {
        if (this.isVirtualView()) {
            return false;
        }
        return !this.getSchema().getPartitionColumns().isEmpty();
    }

    private void runSQL(String query) throws OdpsException {
        this.runSQL("AnonymousSQLTask", query);
    }

    private void runSQL(String taskName, String query) throws OdpsException {
        Map<String, String> hints = NameSpaceSchemaUtils.setSchemaFlagInHints(null, this.model.schemaName);
        Instance i = SQLTask.run(this.odps, this.odps.getDefaultProject(), query, taskName, hints, null);
        i.waitForSuccess();
    }

    private HashMap<String, String> initParamsWithSchema() throws OdpsException {
        return NameSpaceSchemaUtils.initParamsWithSchema(this.model.schemaName);
    }

    private String getCoordinate() {
        return NameSpaceSchemaUtils.getFullName(this.model.projectName, this.model.schemaName, this.model.name);
    }

    private Map<String, String> getMvProperties() {
        this.lazyLoad();
        if (this.model.mvProperties == null) {
            this.model.mvProperties = new HashMap<String, String>();
        }
        return this.model.mvProperties;
    }

    public boolean isAutoRefreshEnabled() {
        return Boolean.parseBoolean(this.getMvProperties().getOrDefault("enable_auto_refresh", "false"));
    }

    public Boolean isAutoSubstituteEnabled() {
        String autoSubstituteEnabledStr = this.getMvProperties().getOrDefault("enable_auto_substitute", null);
        return autoSubstituteEnabledStr == null ? null : Boolean.valueOf(autoSubstituteEnabledStr);
    }

    public Integer getRefreshInterval() {
        String refreshIntervalStr = this.getMvProperties().getOrDefault("refresh_interval_minutes", null);
        return refreshIntervalStr == null ? null : Integer.valueOf(refreshIntervalStr);
    }

    public String getRefreshCron() {
        return this.getMvProperties().getOrDefault("refresh_cron", null);
    }

    public List<Map<String, String>> getRefreshHistory() {
        this.lazyLoadExtendInfo();
        return this.model.refreshHistory;
    }

    public boolean hasRowAccessPolicy() {
        this.lazyLoadExtendInfo();
        return this.model.hasRowAccessPolicy;
    }

    public List<String> getPrimaryKey() {
        this.lazyLoadExtendInfo();
        return this.model.primaryKey;
    }

    public int getAcidDataRetainHours() {
        this.lazyLoadExtendInfo();
        return this.model.acidDataRetainHours;
    }

    public long getCdcSize() {
        this.lazyLoadExtendInfo();
        return this.model.cdcSize;
    }

    public long getCdcRecordNum() {
        this.lazyLoadExtendInfo();
        return this.model.cdcRecordNum;
    }

    public long getCdcLatestVersion() {
        this.lazyLoadExtendInfo();
        return this.model.cdcLatestVersion;
    }

    public Date getCdcLatestTimestamp() {
        this.lazyLoadExtendInfo();
        return this.model.cdcLatestTimestamp;
    }

    public Stream newStream(String streamName) throws OdpsException {
        if (!this.isTransactional()) {
            throw new IllegalArgumentException("only transactional table can attach stream");
        }
        StreamIdentifier identifier = StreamIdentifier.of(this.model.projectName, streamName);
        this.odps.streams().create(identifier, TableIdentifier.of(this.model.projectName, this.model.schemaName, this.model.name));
        return this.odps.streams().get(identifier);
    }

    public void setLifeCycle(int days) throws OdpsException {
        String sql = String.format("ALTER TABLE %s SET LIFECYCLE %d;", this.getCoordinate(), days);
        this.runSQL(sql);
    }

    public void changeOwner(String newOwner) throws OdpsException {
        String target = "table";
        if (this.isVirtualView() || this.isMaterializedView()) {
            target = "view";
        }
        this.runSQL(String.format("ALTER %s %s CHANGEOWNER TO %s;", target, this.getCoordinate(), CommonUtils.quoteStr((String)newOwner)));
    }

    public void changeComment(String newComment) throws OdpsException {
        this.runSQL(String.format("ALTER TABLE %s SET COMMENT %s;", this.getCoordinate(), CommonUtils.quoteStr((String)newComment)));
    }

    public void touch() throws OdpsException {
        this.runSQL(String.format("ALTER TABLE %s TOUCH;", this.getCoordinate()));
    }

    public void changeClusterInfo(ClusterInfo clusterInfo) throws OdpsException {
        this.runSQL(String.format("ALTER TABLE %s %s;", this.getCoordinate(), clusterInfo.toString()));
    }

    public void rename(String newName) throws Exception {
        String target = "table";
        if (this.isVirtualView()) {
            target = "view";
        }
        this.runSQL(String.format("ALTER %s %s RENAME TO %s;", target, this.getCoordinate(), CommonUtils.quoteRef((String)newName)));
        this.model.name = newName;
    }

    public void addColumns(List<Column> columns, boolean ifNotExists) throws Exception {
        this.runSQL(this.generateAddColumnsSQL(columns, ifNotExists));
    }

    private String generateAddColumnsSQL(List<Column> columns, boolean ifNotExists) {
        StringBuilder sb = new StringBuilder();
        sb.append("ALTER TABLE ").append(this.getCoordinate()).append(" ADD COLUMNS ");
        if (ifNotExists) {
            sb.append("IF NOT EXISTS ");
        }
        sb.append("(");
        StringJoiner joiner = new StringJoiner(", ");
        for (Column column : columns) {
            StringBuilder columnDef = new StringBuilder();
            columnDef.append(String.format("%s %s", CommonUtils.quoteRef((String)column.getName()), column.getTypeInfo().getTypeName()));
            if (column.getComment() != null && !column.getComment().isEmpty()) {
                columnDef.append(String.format(" COMMENT %s", CommonUtils.quoteStr((String)column.getComment())));
            }
            joiner.add(columnDef.toString());
        }
        sb.append(joiner).append(");");
        return sb.toString();
    }

    public void dropColumns(List<String> columnNames) throws Exception {
        this.runSQL(this.generateDropColumnsSQL(columnNames));
    }

    private String generateDropColumnsSQL(List<String> columnNames) {
        StringJoiner joiner = new StringJoiner(", ");
        for (String columnName : columnNames) {
            joiner.add(CommonUtils.quoteRef((String)columnName));
        }
        return String.format("ALTER TABLE %s DROP COLUMNS %s;", this.getCoordinate(), joiner);
    }

    public void alterColumnType(String columnName, TypeInfo columnType) throws Exception {
        this.runSQL(String.format("ALTER TABLE %s CHANGE COLUMN %s %s %s;", this.getCoordinate(), columnName, columnName, columnType.getTypeName()));
    }

    public void changeColumnName(String oldColumnName, String newColumnName) throws Exception {
        this.runSQL(String.format("ALTER TABLE %s CHANGE COLUMN %s RENAME TO %s;", this.getCoordinate(), oldColumnName, newColumnName));
    }

    @Root(strict=false)
    private static class ListPartitionSpecsResponse {
        @Element(name="Marker", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        private String marker;
        @Element(name="MaxItems", required=false)
        private Integer maxItems;
        @ElementList(entry="Partition", inline=true, required=false)
        private List<Partition.PartitionSpecModel> partitionSpecs = new LinkedList<Partition.PartitionSpecModel>();

        private ListPartitionSpecsResponse() {
        }
    }

    @Root(name="Partitions", strict=false)
    private static class ListPartitionsResponse {
        @ElementList(entry="Partition", inline=true, required=false)
        private List<Partition.PartitionModel> partitions = new LinkedList<Partition.PartitionModel>();
        @Element(name="Marker", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        private String marker;
        @Element(name="MaxItems", required=false)
        private Integer maxItems;

        private ListPartitionsResponse() {
        }
    }

    public static class SortColumn {
        private String name;
        private Order order;

        SortColumn(String name, String order) {
            this.name = name;
            this.order = Order.valueOf(order.toUpperCase());
        }

        public SortColumn(String name, Order order) {
            this.name = name;
            this.order = order;
        }

        public String getName() {
            return this.name;
        }

        public String getOrder() {
            return this.order.name();
        }

        public String toString() {
            return String.format("%s %s", new Object[]{this.name, this.order});
        }

        public String toStringWithQuote() {
            return String.format("%s %s", new Object[]{CommonUtils.quoteRef((String)this.name), this.order});
        }

        static enum Order {
            ASC,
            DESC;

        }
    }

    public static class ClusterInfo {
        long bucketNum = -1L;
        ClusterType clusterType;
        List<String> clusterCols;
        List<SortColumn> sortCols;

        ClusterInfo() {
        }

        public ClusterInfo(ClusterType clusterType, List<String> clusterCols, List<SortColumn> sortCols, long bucketNum) {
            this.clusterType = clusterType;
            this.clusterCols = clusterCols;
            this.sortCols = sortCols;
            this.bucketNum = bucketNum;
        }

        public String getClusterType() {
            return this.clusterType.name().toLowerCase();
        }

        public long getBucketNum() {
            return this.bucketNum;
        }

        public List<String> getClusterCols() {
            return this.clusterCols;
        }

        public List<SortColumn> getSortCols() {
            return this.sortCols;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.clusterType == ClusterType.HASH) {
                stringBuilder.append(" CLUSTERED BY ");
            } else {
                stringBuilder.append(" RANGE CLUSTERED BY ");
            }
            stringBuilder.append("(").append(this.clusterCols.stream().map(CommonUtils::quoteRef).collect(Collectors.joining(", "))).append(")");
            if (this.sortCols != null && this.sortCols.size() > 0) {
                stringBuilder.append(" SORTED BY ").append("(").append(this.sortCols.stream().map(SortColumn::toStringWithQuote).collect(Collectors.joining(", "))).append(")");
            }
            if (this.bucketNum > 0L) {
                stringBuilder.append(" INTO ").append(this.bucketNum).append(" BUCKETS");
            }
            return stringBuilder.toString();
        }

        static enum ClusterType {
            HASH,
            RANGE;

        }
    }

    public static class ColumnMaskInfo {
        private final String name;
        private final List<String> policyNameList;

        public String getName() {
            return this.name;
        }

        public List<String> getPolicyNameList() {
            return this.policyNameList;
        }

        ColumnMaskInfo(String name, List<String> policyNameList) {
            this.name = name;
            this.policyNameList = policyNameList;
        }
    }

    @Root(name="Table", strict=false)
    static class TableModel {
        @Element(name="Name", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String name;
        @Element(name="TableId", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String ID;
        @Attribute(name="format", required=false)
        private String format;
        @Element(name="Schema", required=false)
        private Schema schema;
        @Element(name="Comment", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String comment;
        @Element(name="Owner", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String owner;
        @Element(name="Project", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String projectName;
        @Element(name="SchemaName", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String schemaName;
        @Element(name="TableLabel", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String tableLabel;
        @Element(name="CryptoAlgo", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String cryptoAlgoName;
        @Element(name="TableMaskInfo", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String tableMaskInfo;
        @Element(name="CreationTime", required=false)
        @Convert(value=SimpleXmlUtils.DateConverter.class)
        Date createdTime;
        @Element(name="LastModifiedTime", required=false)
        @Convert(value=SimpleXmlUtils.DateConverter.class)
        Date lastModifiedTime;
        @Element(name="LastAccessTime", required=false)
        @Convert(value=SimpleXmlUtils.DateConverter.class)
        Date lastAccessTime;
        @Element(name="Type", required=false)
        @Convert(value=TableTypeConverter.class)
        TableType type;
        Date lastMetaModifiedTime;
        Date lastMajorCompactTime;
        boolean isVirtualView;
        boolean isMaterializedViewRewriteEnabled;
        boolean isMaterializedViewOutdated;
        boolean isExternalTable;
        boolean isObjectTable;
        long life = -1L;
        long hubLifecycle = -1L;
        String viewText;
        String viewExpandedText;
        long size;
        long recordNum = -1L;
        boolean isArchived;
        long physicalSize;
        long fileNum;
        boolean isTransactional;
        String reserved;
        Shard shard;
        String schemaVersion;
        String storageHandler;
        String location;
        String resources;
        Map<String, String> serDeProperties;
        ClusterInfo clusterInfo;
        List<String> tableExtendedLabels;
        Map<String, String> mvProperties;
        List<Map<String, String>> refreshHistory;
        boolean hasRowAccessPolicy;
        List<String> primaryKey;
        int acidDataRetainHours;
        StorageTierInfo storageTierInfo;
        TableLifecycleConfig tableLifecycleConfig;
        List<ColumnMaskInfo> columnMaskInfoList;
        long cdcSize = -1L;
        long cdcRecordNum = -1L;
        long cdcLatestVersion = -1L;
        Date cdcLatestTimestamp;

        TableModel() {
        }

        @Root(name="Schema", strict=false)
        static class Schema {
            @Text(required=false)
            String content;

            Schema() {
            }
        }
    }

    public static class TableTypeConverter
    implements Converter<TableType> {
        @Override
        public TableType read(InputNode node) throws Exception {
            String value = node.getValue();
            if (value == null) {
                return null;
            }
            try {
                return TableType.valueOf(value);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        @Override
        public void write(OutputNode node, TableType value) throws Exception {
            node.remove();
        }
    }

    public static enum TableType {
        MANAGED_TABLE,
        VIRTUAL_VIEW,
        EXTERNAL_TABLE,
        MATERIALIZED_VIEW,
        OBJECT_TABLE;

    }
}

