/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.Instance;
import com.aliyun.odps.ListIterator;
import com.aliyun.odps.NoSuchObjectException;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Schema;
import com.aliyun.odps.SchemaFilter;
import com.aliyun.odps.UncheckedOdpsException;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.ElementList;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import com.aliyun.odps.task.SQLTask;
import com.aliyun.odps.utils.ExceptionUtils;
import com.aliyun.odps.utils.StringUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.IOUtils;

public class Schemas
implements Iterable<Schema> {
    private final RestClient client;
    private final Odps odps;

    Schemas(Odps odps) {
        this.odps = odps;
        this.client = odps.getRestClient();
    }

    public Schema get() throws OdpsException {
        if (!StringUtils.isNullOrEmpty((String)this.odps.getCurrentSchema())) {
            throw new OdpsException("current schema not set, use Odps#setCurrentSchema(String) to set current schema");
        }
        return this.get(this.odps.getDefaultProject(), this.odps.getCurrentSchema());
    }

    public Schema get(String schemaName) {
        return this.get(this.odps.getDefaultProject(), schemaName);
    }

    public Schema get(String projectName, String schemaName) {
        ExceptionUtils.checkStringArgumentNotNull("projectName", projectName);
        ExceptionUtils.checkStringArgumentNotNull("schemaName", schemaName);
        Schema.SchemaModel model = new Schema.SchemaModel();
        model.name = schemaName;
        return new Schema(model, projectName, this.odps);
    }

    public boolean exists(String schemaName) throws OdpsException {
        return this.exists(this.odps.getDefaultProject(), schemaName);
    }

    public boolean exists(String projectName, String schemaName) throws OdpsException {
        Schema schema = this.get(projectName, schemaName);
        try {
            schema.reload();
            return true;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
    }

    public void create(String schemaName) throws OdpsException {
        this.create(this.odps.getDefaultProject(), schemaName);
    }

    public void create(String projectName, String schemaName) throws OdpsException {
        this.create(projectName, schemaName, null, false);
    }

    public void create(String projectName, String schemaName, String comment, boolean ifNotExists) throws OdpsException {
        String body;
        ExceptionUtils.checkStringArgumentNotNull("projectName", projectName);
        ExceptionUtils.checkStringArgumentNotNull("schemaName", schemaName);
        Schema.SchemaModel model = new Schema.SchemaModel();
        model.project = projectName;
        model.name = schemaName;
        model.comment = comment;
        model.ifNotExists = ifNotExists;
        String resource = ResourceBuilder.buildSchemaResource(projectName);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/xml");
        try {
            body = SimpleXmlUtils.marshal(model);
        }
        catch (Exception e) {
            throw new OdpsException(e);
        }
        this.client.stringRequest(resource, "POST", null, header, body);
    }

    public void delete(String schemaName) throws OdpsException {
        this.delete(this.odps.getDefaultProject(), schemaName);
    }

    public void delete(String projectName, String schemaName) throws OdpsException {
        ExceptionUtils.checkStringArgumentNotNull("projectName", projectName);
        ExceptionUtils.checkStringArgumentNotNull("schemaName", schemaName);
        String resource = ResourceBuilder.buildSchemaResource(projectName, schemaName);
        this.client.request(resource, "DELETE", null, null, null);
    }

    @Override
    public Iterator<Schema> iterator() {
        return this.iterator(this.odps.getDefaultProject());
    }

    public Iterator<Schema> iterator(String projectName) {
        return new SchemaListIterator(projectName, null);
    }

    public Iterator<Schema> iterator(String projectName, SchemaFilter filter) {
        return new SchemaListIterator(projectName, filter);
    }

    public Iterable<Schema> iterable() {
        return this.iterable(this.odps.getDefaultProject());
    }

    public Iterable<Schema> iterable(String projectName) {
        return () -> new SchemaListIterator(projectName, null);
    }

    private class SchemaListIterator
    extends ListIterator<Schema> {
        String projectName;
        Map<String, String> params = new HashMap<String, String>();
        boolean hasList = false;
        private SchemaFilter filter;

        public SchemaListIterator(String projectName, SchemaFilter filter) {
            ExceptionUtils.checkStringArgumentNotNull("projectName", projectName);
            this.projectName = projectName;
            this.filter = filter;
        }

        @Override
        public List<Schema> list(String marker, long maxItems) {
            if (marker != null) {
                this.params.put("marker", marker);
            }
            if (maxItems >= 0L) {
                this.params.put("maxitems", String.valueOf(maxItems));
            }
            return this.list();
        }

        @Override
        public String getMarker() {
            return this.params.get("marker");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<Schema> getExternalProjectSchemaList(String projectName) throws OdpsException {
            HashMap<String, String> queryHint = new HashMap<String, String>();
            InputStream is = null;
            try {
                is = Schemas.class.getResourceAsStream("/com/aliyun/odps/core/base.conf");
                Properties properties = new Properties();
                properties.load(is);
                String majorVersion = properties.getProperty("epv2flighting");
                if (majorVersion != null && !majorVersion.isEmpty() && !"default".equals(majorVersion)) {
                    queryHint.put("odps.task.major.version", majorVersion);
                }
            }
            catch (Exception properties) {
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
            queryHint.put("odps.sql.select.output.format", "csv");
            Instance i = SQLTask.run(Schemas.this.odps, projectName, "show schemas;", queryHint, null);
            i.waitForSuccess();
            Instance.InstanceResultModel.TaskResult taskResult = i.getRawTaskResults().get(0);
            Instance.TaskStatus.Status taskStatus = Instance.TaskStatus.Status.valueOf(taskResult.status.toUpperCase());
            if (taskStatus != Instance.TaskStatus.Status.SUCCESS) {
                throw new RuntimeException("show schemas failed. instanceId:" + i.getId());
            }
            String result = taskResult.result.getString();
            List<Record> schemalist = SQLTask.parseCsvRecord(result);
            if (schemalist == null || schemalist.isEmpty()) {
                return null;
            }
            ArrayList<Schema> schemas = new ArrayList<Schema>();
            for (Record s : schemalist) {
                Schema.SchemaModel model = new Schema.SchemaModel();
                model.name = s.get(0).toString();
                Schema schema = new Schema(model, projectName, Schemas.this.odps);
                schema.setLoaded(true);
                schemas.add(schema);
            }
            return schemas;
        }

        @Override
        protected List<Schema> list() {
            AtomicReference schemas = new AtomicReference(new ArrayList());
            this.params.put("expectmarker", "true");
            String lastMarker = this.params.get("marker");
            if (this.params.containsKey("marker") && StringUtils.isNullOrEmpty((String)lastMarker)) {
                return null;
            }
            if (this.filter != null) {
                if (this.filter.getName() != null) {
                    this.params.put("name", this.filter.getName());
                }
                if (this.filter.getOwner() != null) {
                    this.params.put("owner", this.filter.getOwner());
                }
            }
            String resource = ResourceBuilder.buildSchemaResource(this.projectName);
            try {
                return Schemas.this.odps.projects().get(this.projectName).executeIfEpv2(() -> {
                    schemas.set(this.getExternalProjectSchemaList(this.projectName));
                    if (schemas.get() == null || ((List)schemas.get()).isEmpty()) {
                        return null;
                    }
                    this.params.put("marker", "");
                    return (List)schemas.get();
                }, () -> {
                    ListSchemasResponse resp = Schemas.this.client.request(ListSchemasResponse.class, resource, "GET", this.params);
                    for (Schema.SchemaModel model : resp.schemas) {
                        Schema schema = new Schema(model, this.projectName, Schemas.this.odps);
                        ((List)schemas.get()).add(schema);
                    }
                    this.params.put("marker", resp.marker);
                    return (List)schemas.get();
                });
            }
            catch (OdpsException e) {
                throw new UncheckedOdpsException(e);
            }
        }
    }

    @Root(name="Schemas", strict=false)
    static class ListSchemasResponse {
        @ElementList(entry="Schema", inline=true, required=false)
        List<Schema.SchemaModel> schemas = new ArrayList<Schema.SchemaModel>();
        @Element(name="Marker", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String marker;
        @Element(name="MaxItems", required=false)
        Integer maxItems;

        ListSchemasResponse() {
        }
    }
}

