/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.LazyLoad;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.util.DateUtils;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import java.util.Date;
import java.util.Map;

public class Schema
extends LazyLoad {
    RestClient client;
    Odps odps;
    SchemaModel model;

    Schema(SchemaModel model, String project, Odps odps) {
        this.model = model;
        this.model.project = project;
        this.odps = odps;
        this.client = odps.getRestClient();
    }

    public String getName() {
        this.lazyLoad();
        return this.model.name;
    }

    public String getProjectName() {
        this.lazyLoad();
        return this.model.project;
    }

    public String getComment() {
        this.lazyLoad();
        return this.model.comment;
    }

    public String getOwner() {
        this.lazyLoad();
        return this.model.owner;
    }

    public String getType() {
        this.lazyLoad();
        return this.model.type;
    }

    public Date getCreateTime() {
        this.lazyLoad();
        return this.model.createTime;
    }

    public Date getModifiedTime() {
        this.lazyLoad();
        return this.model.modifiedTime;
    }

    @Override
    public void reload() throws OdpsException {
        String resource = ResourceBuilder.buildSchemaResource(this.model.project, this.model.name);
        Response resp = this.client.request(resource, "GET", null, null, null);
        try {
            this.model = SimpleXmlUtils.unmarshal(resp, SchemaModel.class);
            Map<String, String> headers = resp.getHeaders();
            this.model.createTime = DateUtils.parseRfc822Date(headers.get("x-odps-creation-time"));
            this.model.modifiedTime = DateUtils.parseRfc822Date(headers.get("Last-Modified"));
        }
        catch (Exception e) {
            throw new OdpsException("Can't bind xml to " + SchemaModel.class, e);
        }
        this.setLoaded(true);
    }

    @Root(name="Schema", strict=false)
    static class SchemaModel {
        @Element(name="Name", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String name;
        @Element(name="Project", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String project;
        @Element(name="Comment", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String comment;
        @Element(name="Type", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String type;
        @Element(name="CreateTime", required=false)
        @Convert(value=SimpleXmlUtils.DateConverter.class)
        Date createTime;
        @Element(name="ModifiedTime", required=false)
        @Convert(value=SimpleXmlUtils.DateConverter.class)
        Date modifiedTime;
        @Element(name="IfNotExists", required=false)
        Boolean ifNotExists;
        @Element(name="Owner", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String owner;

        SchemaModel() {
        }
    }

    static enum SchemaType {
        MANAGED,
        EXTERNAL;

    }
}

