/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.lot.operators;

import apsara.odps.lot.AggregateProtos;
import apsara.odps.lot.Lot;
import com.aliyun.odps.lot.common.AggregationFunction;
import com.aliyun.odps.lot.common.Reference;
import com.aliyun.odps.lot.operators.Operator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Aggregate
extends Operator {
    private List<Reference> groupByColumns;
    private Map<String, AggregationFunction> functions;

    public Aggregate(List<Reference> groupByColumns, Map<String, AggregationFunction> functions) {
        this.groupByColumns = groupByColumns == null ? new ArrayList<Reference>() : groupByColumns;
        this.functions = functions == null ? new HashMap<String, AggregationFunction>() : functions;
    }

    public List<Reference> getGroupByColumns() {
        return this.groupByColumns;
    }

    public Map<String, AggregationFunction> getFunctions() {
        return this.functions;
    }

    @Override
    public Lot.LogicalOperator toProtoBuf() {
        assert (this.getParents().size() == 1);
        Lot.LogicalOperator.Builder builder = Lot.LogicalOperator.newBuilder();
        AggregateProtos.Aggregate.Builder agg = AggregateProtos.Aggregate.newBuilder();
        agg.setId(this.getId());
        agg.setParentId(this.getParents().get(0).getId());
        for (Map.Entry<String, AggregationFunction> item : this.functions.entrySet()) {
            AggregateProtos.Aggregate.Functions.Builder func = AggregateProtos.Aggregate.Functions.newBuilder();
            func.setAlias(item.getKey());
            func.setFunction(item.getValue().toProtoBuf());
            agg.addFunctions(func);
        }
        for (Reference ref : this.groupByColumns) {
            agg.addGroupByColumns(ref.toProtoBuf().getReference());
        }
        builder.setAggregate(agg.build());
        return builder.build();
    }
}

