/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.graph.job;

import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Task;
import com.aliyun.odps.conf.Configuration;
import com.aliyun.odps.conf.Configured;
import com.aliyun.odps.graph.JobConf;
import com.aliyun.odps.graph.job.JobRunner;
import com.aliyun.odps.graph.job.NetworkRunningJob;
import com.aliyun.odps.mapred.RunningJob;
import com.aliyun.odps.mapred.conf.SessionState;
import com.aliyun.odps.task.GraphTask;
import com.aliyun.odps.utils.CommonUtils;
import com.google.gson.GsonBuilder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class NetworkJobRunner
extends Configured
implements JobRunner {
    @Override
    public RunningJob submit() throws OdpsException {
        String taskName = CommonUtils.generateGraphTaskName();
        GraphTask task = new GraphTask(taskName);
        Task.Properties jobConf = new Task.Properties();
        JobConf confInConsole = new JobConf((Configuration)SessionState.get().getDefaultJob());
        JobConf confInJob = new JobConf(this.getConf());
        HashMap settings = new HashMap();
        Iterator settingsIter = confInConsole.iterator();
        while (settingsIter.hasNext()) {
            Map.Entry entry = (Map.Entry)settingsIter.next();
            settings.put(entry.getKey(), entry.getValue());
        }
        Iterator it = confInConsole.iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            if (((String)entry.getKey()).equals("odps.graph.cache.resources") || ((String)entry.getKey()).equals("odps.graph.classpath.resources")) continue;
            confInJob.set((String)entry.getKey(), (String)entry.getValue());
        }
        String[] resources = SessionState.get().getDefaultJob().getResources();
        if (resources != null) {
            for (String resource : resources) {
                confInJob.addCacheResourcesToClassPath(resource);
            }
        }
        jobConf.addProperty(new Task.Property("odps.graph.new.sdk", "true"));
        int priority = confInJob.getJobPriority();
        Iterator itInSession = confInJob.iterator();
        while (itInSession.hasNext()) {
            Map.Entry entry = (Map.Entry)itInSession.next();
            Task.Property pType = new Task.Property((String)entry.getKey(), (String)entry.getValue());
            jobConf.addProperty(pType);
        }
        try {
            String json = new GsonBuilder().disableHtmlEscaping().create().toJson(settings);
            task.setProperty("settings", json);
        }
        catch (Exception e) {
            throw new OdpsException(e.getMessage(), (Throwable)e);
        }
        Map aliases = SessionState.get().getAliases();
        if (aliases != null) {
            try {
                String json = new GsonBuilder().disableHtmlEscaping().create().toJson((Object)aliases);
                task.setProperty("aliases", json);
            }
            catch (Exception e) {
                throw new OdpsException(e.getMessage(), (Throwable)e);
            }
        }
        task.setJobConf(jobConf);
        Odps odps = SessionState.get().getOdps();
        String project = odps.getDefaultProject();
        Instance instance = GraphTask.run((Odps)odps, (String)project, (GraphTask)task, (int)priority, (String)confInJob.get("odps.running.cluster", null));
        if (instance == null) {
            throw new RuntimeException("Client-side submit job failed.");
        }
        NetworkRunningJob rJob = new NetworkRunningJob((Task)task, instance);
        if (SessionState.get().isCostMode()) {
            rJob.setIsCostMode(true);
        }
        System.err.println();
        System.err.println("ID = " + rJob.getInstanceID());
        this.printLogViewIfNecessary(instance);
        return rJob;
    }

    private void printLogViewIfNecessary(Instance instance) {
        try {
            String log = SessionState.get().getOdps().logview().generateLogView(instance, 168L);
            System.err.println(log);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

