/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.graph;

import com.aliyun.odps.graph.Edge;
import com.aliyun.odps.graph.LoadingVertexResolver;
import com.aliyun.odps.graph.Vertex;
import com.aliyun.odps.graph.VertexChanges;
import com.aliyun.odps.io.Writable;
import com.aliyun.odps.io.WritableComparable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class RemoveDuplicatesLoadingResolver<I extends WritableComparable, V extends Writable, E extends Writable, M extends Writable>
extends LoadingVertexResolver<I, V, E, M> {
    @Override
    public Vertex<I, V, E, M> resolve(I vertexId, VertexChanges<I, V, E, M> vertexChanges) throws IOException {
        Vertex<I, V, E, M> vertex = this.addVertexIfDesired(vertexId, vertexChanges);
        if (vertex != null) {
            this.addEdges(vertexId, vertex, vertexChanges);
        } else {
            System.err.println("Ignore all addEdgeRequests for vertex#" + vertexId);
        }
        return vertex;
    }

    protected Vertex<I, V, E, M> addVertexIfDesired(I vertexId, VertexChanges<I, V, E, M> vertexChanges) {
        Vertex<I, V, E, M> vertex = null;
        if (this.hasVertexAdditions(vertexChanges)) {
            vertex = vertexChanges.getAddedVertexList().get(0);
        }
        return vertex;
    }

    protected void addEdges(I vertexId, Vertex<I, V, E, M> vertex, VertexChanges<I, V, E, M> vertexChanges) throws IOException {
        HashSet<I> destVertexId = new HashSet<I>();
        if (vertex.hasEdges()) {
            List<Edge<I, E>> edgeList = vertex.getEdges();
            Iterator<Edge<I, E>> edges = edgeList.iterator();
            while (edges.hasNext()) {
                Edge<I, E> edge = edges.next();
                if (destVertexId.contains(edge.getDestVertexId())) {
                    edges.remove();
                    continue;
                }
                destVertexId.add(edge.getDestVertexId());
            }
        }
        if (this.hasEdgeAdditions(vertexChanges)) {
            for (Edge<I, E> edge : vertexChanges.getAddedEdgeList()) {
                if (destVertexId.contains(edge.getDestVertexId())) continue;
                destVertexId.add(edge.getDestVertexId());
                vertex.addEdge(edge.getDestVertexId(), edge.getValue());
            }
        }
    }

    protected boolean hasVertexAdditions(VertexChanges<I, V, E, M> changes) {
        return changes != null && changes.getAddedVertexList() != null && !changes.getAddedVertexList().isEmpty();
    }

    protected boolean hasEdgeAdditions(VertexChanges<I, V, E, M> changes) {
        return changes != null && changes.getAddedEdgeList() != null && !changes.getAddedEdgeList().isEmpty();
    }
}

