/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.udf.local.util.fs;

import com.aliyun.odps.io.SourceInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.BufferOverflowException;

public class LocalInputStream
extends SourceInputStream {
    private FileInputStream fileInputStream;
    private File file;
    private long currentPos;

    public LocalInputStream(File file) throws IOException {
        this.file = file;
        this.fileInputStream = new FileInputStream(file);
        this.currentPos = 0L;
    }

    public int read(byte[] b, int offset, int length) throws IOException {
        int read = this.fileInputStream.read(b, offset, length);
        this.currentPos += (long)read;
        return read;
    }

    public int read(byte[] b) throws IOException {
        int read = this.fileInputStream.read(b);
        this.currentPos += (long)read;
        return read;
    }

    public int read() throws IOException {
        int read = this.fileInputStream.read();
        if (read > 0) {
            ++this.currentPos;
        }
        return read;
    }

    public long skip(long n) throws IOException {
        long s = this.fileInputStream.skip(n);
        if (s > 0L) {
            this.currentPos += s;
        }
        return s;
    }

    public String getFileName() {
        return this.file.getName();
    }

    public long getFileSize() {
        return this.file.length();
    }

    public long getSplitStart() {
        return 0L;
    }

    public long getSplitSize() {
        return this.file.length();
    }

    public long getCurrentPos() throws IOException {
        return this.currentPos;
    }

    public int readToEnd(byte[] buffer) throws IOException, BufferOverflowException {
        long sizeToRead = this.getSplitSize();
        if ((long)buffer.length < sizeToRead) {
            throw new BufferOverflowException();
        }
        if (sizeToRead > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("readToEnd does not support size larger than Integer.MAX_VALUE.Please use multiple read(byte[] buffer, int offset, int length) to read large files.");
        }
        int readSize = this.fileInputStream.read(buffer, 0, (int)sizeToRead);
        return readSize;
    }

    public SourceInputStream cloneStream() throws IOException {
        return new LocalInputStream(this.file);
    }

    public void adjustMaxCloneLimit(int limit) {
        throw new UnsupportedOperationException("no need to adjust max clone limit for local file.");
    }

    public long getBytesRead() {
        throw new UnsupportedOperationException("getBytesRead not supported for local file.");
    }
}

