/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.udf.local.runner;

import com.aliyun.odps.Odps;
import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.udf.Aggregator;
import com.aliyun.odps.udf.UDF;
import com.aliyun.odps.udf.UDFException;
import com.aliyun.odps.udf.UDTF;
import com.aliyun.odps.udf.local.LocalRunError;
import com.aliyun.odps.udf.local.LocalRunException;
import com.aliyun.odps.udf.local.runner.AggregatorRunner;
import com.aliyun.odps.udf.local.runner.BaseRunner;
import com.aliyun.odps.udf.local.runner.UDFRunner;
import com.aliyun.odps.udf.local.runner.UDTFRunner;
import com.aliyun.odps.udf.local.util.ClassUtils;
import org.apache.commons.cli.CommandLine;

public class RunnerFactory {
    public static BaseRunner getRunner(CommandLine cmdl, Odps odps, TableInfo tableInfo) throws LocalRunException, UDFException {
        String className = cmdl.getOptionValue("c");
        Object obj = null;
        try {
            obj = ClassUtils.newInstance(RunnerFactory.class.getClassLoader(), className);
        }
        catch (Exception e) {
            throw new LocalRunError("Invalid class name:" + className + "\n" + e.getMessage());
        }
        if (obj instanceof UDF) {
            return new UDFRunner(odps, className, tableInfo);
        }
        if (obj instanceof UDTF) {
            return new UDTFRunner(odps, className);
        }
        if (obj instanceof Aggregator) {
            return new AggregatorRunner(odps, className);
        }
        throw new LocalRunError("Unsupported class:" + className + ", it must extends from one of the following:\ncom.aliyun.odps.udf.UDF\ncom.aliyun.odps.udf.UDTF\ncom.aliyun.odps.udf.Aggregator\n");
    }
}

