/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.request.cupid.webproxy;

import com.aliyun.odps.request.cupid.webproxy.ResponseCode;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class WebProxyCall {
    private static final Logger LOG = Logger.getLogger(WebProxyCall.class);
    private static WebProxyCall INSTANCE = new WebProxyCall();

    public static WebProxyCall getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callWebProxy(String url) {
        String resultCode = "";
        try (DefaultHttpClient httpclient = new DefaultHttpClient();){
            HttpGet httpget = new HttpGet(url);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpget);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                String responseString;
                HttpEntity entity = response.getEntity();
                resultCode = ResponseCode.CALLRESPONSEERROR;
                if (entity != null && (responseString = EntityUtils.toString((HttpEntity)entity)).contains("Spark Jobs") && responseString.contains("Stages") && responseString.contains("Storage") && responseString.contains("Environment") && responseString.contains("Executors")) {
                    resultCode = ResponseCode.CALLSUCCESS;
                }
            } else {
                resultCode = statusCode == 302 || statusCode == 301 ? ResponseCode.CALLFORBIDDEN : ResponseCode.OTHER_RESPONSE + String.valueOf(statusCode);
            }
        }
        LOG.info((Object)("WebProxyCall result " + resultCode));
        if (!resultCode.equals(ResponseCode.CALLSUCCESS)) {
            System.exit(1);
        }
    }
}

