/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.request.cupid.webproxy;

import com.aliyun.odps.request.cupid.webproxy.WebProxyCall;
import org.apache.log4j.Logger;

public class PollCallWebProxy {
    private static final Logger LOG = Logger.getLogger(WebProxyCall.class);
    private static final PollCallWebProxy INSTANCE = new PollCallWebProxy();

    public static PollCallWebProxy getInstance() {
        return INSTANCE;
    }

    public void startPoll(String url, int callInterval) {
        CallThread callThread = new CallThread(url, callInterval);
        callThread.setDaemon(true);
        callThread.start();
    }

    class CallThread
    extends Thread {
        private String callUrl;
        private int callInterval;

        CallThread(String url, int callInterval) {
            this.callUrl = url;
            this.callInterval = callInterval;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        WebProxyCall.getInstance().callWebProxy(this.callUrl);
                        Thread.sleep(this.callInterval * 1000);
                    }
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)("in call webproxy " + e.getMessage()));
                    continue;
                }
                break;
            }
        }
    }
}

