/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid.requestcupid;

import apsara.odps.cupid.protocol.CupidTaskParamProtos;
import com.aliyun.odps.Instance;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.cupid.CupidSession;
import com.aliyun.odps.cupid.requestcupid.ApplicationMetaUtil;
import com.aliyun.odps.cupid.requestcupid.YarnClientImplUtil;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class JobViewUtil {
    private static Logger logger = Logger.getLogger(JobViewUtil.class);
    private CupidSession cupidSession;

    public JobViewUtil(CupidSession cupidSession) {
        this.cupidSession = cupidSession;
        if (this.getWebproxyEndpoint() == null) {
            this.setWebproxyEndpoint("http://10.101.207.27:6116/api");
        }
        if (this.getTrackurlHost() == null) {
            this.setTrackurlHost("http://10.101.214.140:9998");
        }
    }

    public String getWebproxyEndpoint() {
        try {
            return this.cupidSession.conf.get("odps.cupid.webproxy.endpoint");
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public void setWebproxyEndpoint(String webproxyEndpoint) {
        this.cupidSession.conf.set("odps.cupid.webproxy.endpoint", webproxyEndpoint);
    }

    public String getTrackurlHost() {
        try {
            return this.cupidSession.conf.get("odps.moye.trackurl.host");
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public void setTrackurlHost(String trackurlHost) {
        this.cupidSession.conf.set("odps.moye.trackurl.host", trackurlHost);
    }

    public String generateJobView(String instanceID, int hours) {
        this.cupidSession.conf.set("odps.cupid.job.capability.duration.hours", Integer.toString(hours));
        return this.generateJobView(instanceID);
    }

    public String generateJobView(String instanceID) {
        String jobViewUrl;
        Instance currentInstance = this.cupidSession.odps().instances().get(instanceID);
        String applicationId = this.getApplicationID(instanceID);
        try {
            jobViewUrl = YarnClientImplUtil.genCupidTrackUrl(currentInstance, applicationId, "", this.cupidSession);
        }
        catch (OdpsException e) {
            logger.error((Object)("getCupidTrackUrl via applicationId: " + applicationId + " failed with errMsg: " + e.getMessage()), (Throwable)e);
            return null;
        }
        return jobViewUrl;
    }

    private String getApplicationID(String instanceID) {
        this.cupidSession.setJobLookupName(instanceID);
        CupidTaskParamProtos.ApplicationMeta applicationMeta = null;
        try {
            applicationMeta = ApplicationMetaUtil.getCupidInstanceMeta(instanceID, this.cupidSession);
        }
        catch (Exception e) {
            logger.error((Object)("getCupidInstanceMeta via instanceId: " + instanceID + " failed with errMsg: " + e.getMessage()), (Throwable)e);
        }
        if (applicationMeta == null) {
            logger.error((Object)("getCupidInstanceMeta via instanceId: " + instanceID + " is null."));
            return null;
        }
        return applicationMeta.getApplicationId();
    }
}

