/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid.interaction;

import com.aliyun.odps.cupid.interaction.ConsoleReader;
import com.aliyun.odps.cupid.interaction.InteractionClient;
import com.aliyun.odps.cupid.interaction.InteractionClientFactory;
import com.aliyun.odps.cupid.interaction.Protocol;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class UserClient {
    private static final int EOF = -1;
    private String endpoint;
    private String token;
    private String routeInfo;
    private InteractionClient client;
    private long defaultTimeout = 10000L;
    private long defaultWaitAppTimeout = 300000L;
    private Object startLock = new Object();
    private boolean isAppStart = false;

    public UserClient(String endpoint) {
        this.endpoint = endpoint;
    }

    public void connect() {
        this.connect(this.defaultTimeout);
    }

    public void connect(long timeout) {
        if (this.client != null && !this.client.isClosed()) {
            throw new RuntimeException("The client is connected!");
        }
        this.client = InteractionClientFactory.getUserClient(Protocol.WEBSOCKET.name(), this.endpoint);
        this.token = this.client.getToken();
        this.routeInfo = this.client.getRouteInfo();
        long endTime = System.currentTimeMillis() + timeout;
        while (this.client.isClosed()) {
            if (System.currentTimeMillis() > endTime) {
                throw new RuntimeException("Connect timeout! Check your endpoint and networks~");
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {}
        }
        new Thread(new InputWorker(this.client.getInputStream())).start();
        new Thread(new OutputWorker(this.client.getOutputStream())).start();
    }

    public String getToken() {
        return this.token;
    }

    public String getRouteInfo() {
        return this.routeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startImmediately() {
        Object object = this.startLock;
        synchronized (object) {
            this.isAppStart = true;
            this.startLock.notify();
        }
    }

    class OutputWorker
    implements Runnable {
        private OutputStream out;
        private int result = 1;

        OutputWorker(OutputStream out) {
            this.out = out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = UserClient.this.startLock;
            synchronized (object) {
                if (!UserClient.this.isAppStart) {
                    try {
                        UserClient.this.startLock.wait(UserClient.this.defaultWaitAppTimeout);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            try {
                ConsoleReader reader = new ConsoleReader(System.in, new OutputStreamWriter(this.out, "UTF-8"));
                while (reader.readLine() != null) {
                }
                this.result = 0;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (this.out != null) {
                        this.out.close();
                    }
                }
                catch (IOException iOException) {}
                System.out.println();
                System.out.println("Bye!");
                System.exit(this.result);
            }
        }
    }

    class InputWorker
    implements Runnable {
        private InputStream in;
        private boolean first = true;
        private int result = 1;

        InputWorker(InputStream in) {
            this.in = in;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                int b;
                while ((b = this.in.read()) != -1) {
                    if (this.first) {
                        try {
                            Thread.sleep(8000L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        this.first = false;
                    }
                    System.out.write(b & 0xFF);
                    System.out.flush();
                }
                this.result = 0;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (this.in != null) {
                        this.in.close();
                    }
                }
                catch (IOException iOException) {}
                System.out.println();
                System.out.println("Bye!");
                System.exit(this.result);
            }
        }
    }
}

