/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.ship.upload;

import com.aliyun.odps.ship.common.BlockInfo;
import com.aliyun.odps.ship.common.Constants;
import com.aliyun.odps.ship.common.Util;
import com.aliyun.odps.tunnel.TunnelException;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.cli.ParseException;

public class BlockInfoBuilder {
    private long blockSize = Constants.DEFAULT_BLOCK_SIZE * 1024L * 1024L;

    public ArrayList<BlockInfo> buildBlockIndex(File file) throws IOException, TunnelException, ParseException {
        ArrayList<BlockInfo> blockIndex = new ArrayList<BlockInfo>();
        this.build(file, blockIndex);
        return blockIndex;
    }

    public void setBlockSize(long blockSize) {
        this.blockSize = blockSize;
    }

    public long getFileSize(File file) throws IOException, TunnelException, ParseException {
        long totalBytes = 0L;
        if (file.isDirectory()) {
            File[] fileList = file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile();
                }
            });
            for (File f : fileList = Util.sortFiles(fileList)) {
                totalBytes += this.getFileSize(f);
            }
        } else {
            long fileLength = file.length();
            totalBytes += fileLength;
        }
        return totalBytes;
    }

    private void build(File file, ArrayList<BlockInfo> blockIndex) throws IOException, TunnelException, ParseException {
        block3: {
            long length;
            block4: {
                block2: {
                    if (!file.isDirectory()) break block2;
                    File[] fileList = file.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return pathname.isFile();
                        }
                    });
                    for (File f : fileList = Util.sortFiles(fileList)) {
                        this.build(f, blockIndex);
                    }
                    break block3;
                }
                if (this.blockSize != -1L) break block4;
                if (file.length() <= 0L) break block3;
                blockIndex.add(new BlockInfo(Long.valueOf(blockIndex.size() + 1), file, 0L, file.length()));
                break block3;
            }
            long fileLength = file.length();
            for (long i = 0L; i < fileLength; i += length) {
                length = i + this.blockSize < fileLength ? this.blockSize : fileLength - i;
                BlockInfo blockInfo = new BlockInfo(Long.valueOf(blockIndex.size() + 1), file, i, length);
                blockIndex.add(blockInfo);
            }
        }
    }
}

