/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.cupid;

import apsara.odps.cupid.protocol.CupidTaskParamProtos;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.cupid.CupidConf;
import com.aliyun.odps.cupid.CupidSession;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.cupid.common.CupidSessionConf;
import com.aliyun.openservices.odps.console.cupid.common.SparkJobUtils;
import com.aliyun.openservices.odps.console.cupid.common.YarnConstants;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.StringUtils;

public class SparkJobCommand
extends AbstractCommand {
    public static final String[] HELP_TAGS = new String[]{"spark"};
    private static final String LIST_CMD = "list";
    private static final String INFO_CMD = "info";
    private static final String KILL_CMD = "kill";
    private static final String SEARCH_CMD = "search";
    private static final String VIEW_CMD = "view";
    private static final String INSTANCE_ID_ARG = "instanceId";
    private static final String APPLICATION_ID_ARG = "appId";
    private static final String STATE_ARG = "state";
    private String subCommand;
    private String instanceId;
    private String applicationId;
    private String applicationName;
    private String stateFilter = null;
    private CupidConf cupidConf;

    String getInstanceId() {
        return this.instanceId;
    }

    String getApplicationId() {
        return this.applicationId;
    }

    String getSubCommand() {
        return this.subCommand;
    }

    String getApplicationName() {
        return this.applicationName;
    }

    public static void printUsage(PrintStream stream) {
        stream.println("Usage: spark list [-s <yarnState>(NEW,RUNNING,FINISHED,FAILED,KILLED)];");
        stream.println("       spark info [-i <instanceId>] [-a <appId>];");
        stream.println("       spark kill [-i <instanceId>] [-a <appId>];");
        stream.println("       spark view [-i <instanceId>] [-a <appId>];");
        stream.println("       spark search <appNameStr>;");
    }

    public SparkJobCommand(String commandText, ExecutionContext context, String subCommand, String[] args) throws ODPSConsoleException {
        super(commandText, context);
        this.subCommand = subCommand;
        try {
            this.parseArgs(args);
        }
        catch (ParseException e) {
            throw new ODPSConsoleException(e.getMessage());
        }
    }

    public static SparkJobCommand parse(String cmd, ExecutionContext cxt) throws ODPSConsoleException {
        String regStr = "\\s*spark\\s+(list|info|kill|search|view)([\\s\\S]*)";
        Pattern pattern = Pattern.compile(regStr, 2);
        Matcher matcher = pattern.matcher(cmd);
        if (matcher.matches()) {
            String args = matcher.group(2).replaceAll("\\s+", " ").trim();
            return new SparkJobCommand(cmd, cxt, matcher.group(1), args.split(" "));
        }
        return null;
    }

    private static Options initListOptions() {
        Options options = new Options();
        Option stateOption = new Option("s", STATE_ARG, true, "optional, yarn application state filter");
        stateOption.setRequired(false);
        options.addOption(stateOption);
        return options;
    }

    private static Options initSearchOptions() {
        return new Options();
    }

    private static Options initKillOptions() {
        return SparkJobCommand.initCommonOptions();
    }

    private static Options initInfoOptions() {
        return SparkJobCommand.initCommonOptions();
    }

    private static Options initViewOptions() {
        return SparkJobCommand.initCommonOptions();
    }

    private static Options initCommonOptions() {
        Options options = new Options();
        Option instanceIdOption = new Option("i", INSTANCE_ID_ARG, true, "optional, instance id");
        instanceIdOption.setRequired(false);
        options.addOption(instanceIdOption);
        Option applicationIdOption = new Option("a", APPLICATION_ID_ARG, true, "optional, application id");
        applicationIdOption.setRequired(false);
        options.addOption(applicationIdOption);
        return options;
    }

    private void parseArgs(String[] args) throws ParseException, ODPSConsoleException {
        Options options;
        DefaultParser parser = new DefaultParser();
        if (LIST_CMD.equalsIgnoreCase(this.subCommand)) {
            options = SparkJobCommand.initListOptions();
        } else if (INFO_CMD.equalsIgnoreCase(this.subCommand)) {
            options = SparkJobCommand.initInfoOptions();
        } else if (KILL_CMD.equalsIgnoreCase(this.subCommand)) {
            options = SparkJobCommand.initKillOptions();
        } else if (SEARCH_CMD.equalsIgnoreCase(this.subCommand)) {
            this.applicationName = StringUtils.join((Object[])args, (String)" ");
            options = SparkJobCommand.initSearchOptions();
        } else if (VIEW_CMD.equalsIgnoreCase(this.subCommand)) {
            options = SparkJobCommand.initViewOptions();
        } else {
            SparkJobCommand.printUsage(System.err);
            throw new ODPSConsoleException("Invalid command \"" + this.subCommand + "\". ");
        }
        CommandLine cmd = parser.parse(options, args);
        if (INFO_CMD.equalsIgnoreCase(this.subCommand) || KILL_CMD.equalsIgnoreCase(this.subCommand) || VIEW_CMD.equalsIgnoreCase(this.subCommand)) {
            this.setInstanceIdOrAppId(cmd);
        } else if (LIST_CMD.equalsIgnoreCase(this.subCommand) && cmd.hasOption(STATE_ARG)) {
            String statesString = cmd.getOptionValue(STATE_ARG);
            String[] states = statesString.split(",");
            this.stateFilter = Arrays.stream(states).map(f -> String.valueOf(YarnConstants.getAppStateCode(f))).collect(Collectors.joining(","));
        }
        this.cupidConf = CupidSessionConf.getBasicCupidConf(this.getContext());
    }

    private void setInstanceIdOrAppId(CommandLine cmd) throws ODPSConsoleException {
        if (cmd.hasOption(INSTANCE_ID_ARG)) {
            this.instanceId = cmd.getOptionValue(INSTANCE_ID_ARG);
        } else if (cmd.hasOption(APPLICATION_ID_ARG)) {
            this.applicationId = cmd.getOptionValue(APPLICATION_ID_ARG);
        } else {
            throw new ODPSConsoleException("Need to specify at least one of the instanceId and applicationId");
        }
    }

    public void run() throws ODPSConsoleException, OdpsException {
        if (LIST_CMD.equalsIgnoreCase(this.subCommand)) {
            this.listSparkJobs();
        } else if (INFO_CMD.equalsIgnoreCase(this.subCommand)) {
            this.sparkJobInfo();
        } else if (KILL_CMD.equalsIgnoreCase(this.subCommand)) {
            this.killSparkJob();
        } else if (SEARCH_CMD.equalsIgnoreCase(this.subCommand)) {
            this.searchSparkJob();
        } else if (VIEW_CMD.equalsIgnoreCase(this.subCommand)) {
            this.generateSparkViews();
        }
    }

    private void listSparkJobs() throws ODPSConsoleException {
        CupidSession session = new CupidSession(this.cupidConf);
        CupidTaskParamProtos.ApplicationMetaList applicationMetaList = SparkJobUtils.getApplicationMetaList(session, this.stateFilter);
        String[] title = new String[]{"StartTime", "InstanceId", "State", "RunningMode", "ApplicationName"};
        int[] columnPercent = new int[]{20, 20, 10, 10, 40};
        ODPSConsoleUtils.formaterTableRow((String[])title, (int[])columnPercent, (int)this.getContext().getConsoleWidth());
        String[] attr = new String[5];
        for (CupidTaskParamProtos.ApplicationMeta applicationMeta : applicationMetaList.getApplicationMetaListList()) {
            long sTime = applicationMeta.getStartedTime();
            Date date = new Date(sTime);
            attr[0] = ODPSConsoleUtils.formatDate((Date)date);
            attr[1] = applicationMeta.getInstanceId();
            long intState = applicationMeta.getYarnApplicationState();
            attr[2] = YarnConstants.getAppStateStr(intState);
            attr[3] = applicationMeta.getRunningMode();
            attr[4] = applicationMeta.getApplicationName();
            ODPSConsoleUtils.formaterTableRow((String[])attr, (int[])columnPercent, (int)this.getContext().getConsoleWidth());
        }
    }

    private void sparkJobInfo() throws ODPSConsoleException {
        CupidSession session = new CupidSession(this.cupidConf);
        CupidTaskParamProtos.ApplicationMeta applicationMeta = SparkJobUtils.getApplicationMeta(this.instanceId, this.applicationId, session);
        this.getWriter().writeError(applicationMeta.toString());
    }

    private void killSparkJob() throws ODPSConsoleException, OdpsException {
        CupidSession session = new CupidSession(this.cupidConf);
        CupidTaskParamProtos.ApplicationMeta applicationMeta = SparkJobUtils.getApplicationMeta(this.instanceId, this.applicationId, session);
        try {
            this.getCurrentOdps().instances().get(applicationMeta.getInstanceId()).stop();
            this.getWriter().writeError("please check instance status. [status " + applicationMeta.getInstanceId() + ";]");
        }
        catch (Exception ex) {
            this.getWriter().writeError("stop instance failed. " + ex.getMessage());
        }
        if (applicationMeta.getFinalApplicationStatus() == (long)YarnConstants.FinalApplicationStatus.UNDEFINED.ordinal()) {
            CupidTaskParamProtos.ApplicationMeta.Builder updateMeta = CupidTaskParamProtos.ApplicationMeta.newBuilder();
            updateMeta.setYarnApplicationState((long)YarnConstants.AppState.KILLED.ordinal());
            updateMeta.setFinalApplicationStatus((long)YarnConstants.FinalApplicationStatus.FAILED.ordinal());
            updateMeta.setFinishedTime(System.currentTimeMillis());
            SparkJobUtils.updateApplicationMeta(applicationMeta.getApplicationId(), session, updateMeta.build());
        }
    }

    private void searchSparkJob() throws ODPSConsoleException {
        CupidSession session = new CupidSession(this.cupidConf);
        CupidTaskParamProtos.ApplicationMetaList applicationMetaList = SparkJobUtils.getApplicationMetaList(session);
        for (CupidTaskParamProtos.ApplicationMeta applicationMeta : applicationMetaList.getApplicationMetaListList()) {
            Pattern pattern = Pattern.compile(this.applicationName, 2);
            Matcher matcher = pattern.matcher(applicationMeta.getApplicationName());
            if (!matcher.find() && !applicationMeta.getApplicationName().equalsIgnoreCase(this.applicationName)) continue;
            this.getWriter().writeError(String.format("instanceId: %s, appName: %s", applicationMeta.getInstanceId(), applicationMeta.getApplicationName()));
        }
    }

    private void generateSparkViews() throws ODPSConsoleException, OdpsException {
        this.getWriter().writeError(String.format("Some env might need to set following flags.\nset %s=****\nset %s=****\n", "odps.moye.trackurl.host", "odps.cupid.webproxy.endpoint"));
        String jobview = SparkJobUtils.jobViewService(this.getContext(), this.instanceId, this.applicationId);
        String logview = SparkJobUtils.logViewService(this.getContext(), this.instanceId, this.applicationId);
        this.getWriter().writeError(String.format("jobview:\n%s", jobview));
        this.getWriter().writeError(String.format("logview:\n%s", logview));
    }
}

