/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.utils.jline;

import com.aliyun.openservices.odps.console.utils.CommandParserUtils;
import com.aliyun.openservices.odps.console.utils.jline.Pair;
import java.util.ArrayList;
import java.util.List;
import org.jline.reader.Highlighter;
import org.jline.reader.LineReader;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;

public class ODPSDefaultHighlighter
implements Highlighter {
    private static final AttributedStyle STYLE = AttributedStyle.DEFAULT.bold().foreground(5);
    private static final AttributedStyle STYLE_OFF = AttributedStyle.DEFAULT.boldOff().foregroundOff();

    public AttributedString highlight(LineReader reader, String buffer) {
        AttributedStringBuilder sb = new AttributedStringBuilder();
        int currentIndex = 0;
        for (Pair<Integer, Integer> range : this.getIndexRangesToHighlight(buffer)) {
            if ((Integer)range.first > currentIndex) {
                sb.append((CharSequence)buffer.substring(currentIndex, (Integer)range.first));
            } else if ((Integer)range.first < currentIndex) continue;
            sb.style(STYLE);
            sb.append((CharSequence)buffer.substring((Integer)range.first, (Integer)range.second));
            sb.style(STYLE_OFF);
            currentIndex = (Integer)range.second;
        }
        sb.append((CharSequence)buffer.substring(currentIndex));
        return sb.toAttributedString();
    }

    private List<Pair<Integer, Integer>> getIndexRangesToHighlight(String buffer) {
        buffer = buffer.toUpperCase();
        ArrayList<String> highlightedWords = new ArrayList<String>(CommandParserUtils.getAllCommandKeyWords());
        ArrayList<Pair<Integer, Integer>> indexRanges = new ArrayList<Pair<Integer, Integer>>();
        for (String reservedWord : highlightedWords) {
            int start;
            int end = 0;
            while ((start = buffer.indexOf(reservedWord.toUpperCase(), end)) != -1) {
                end = start + reservedWord.length();
                if (start != 0 && !Character.isWhitespace(buffer.charAt(start - 1)) || end != buffer.length() && !Character.isWhitespace(buffer.charAt(end)) && buffer.charAt(end) != ';') continue;
                indexRanges.add(new Pair<Integer, Integer>(start, end));
            }
        }
        return this.mergeIndexRanges(indexRanges);
    }

    private List<Pair<Integer, Integer>> mergeIndexRanges(List<Pair<Integer, Integer>> indexRanges) {
        ArrayList<Pair<Integer, Integer>> mergedIndexRanges = new ArrayList<Pair<Integer, Integer>>();
        indexRanges.sort((o1, o2) -> {
            if ((Integer)o1.first < (Integer)o2.first) {
                return -1;
            }
            if ((Integer)o1.first > (Integer)o2.first) {
                return 1;
            }
            if ((Integer)o1.second > (Integer)o2.second) {
                return -1;
            }
            if ((Integer)o1.second < (Integer)o2.second) {
                return 1;
            }
            return 0;
        });
        for (int i = 0; i < indexRanges.size(); ++i) {
            int start = (Integer)indexRanges.get((int)i).first;
            int end = (Integer)indexRanges.get((int)i).second;
            int j = i + 1;
            while (j < indexRanges.size()) {
                int curStart = (Integer)indexRanges.get((int)j).first;
                int curEnd = (Integer)indexRanges.get((int)j).second;
                if (curStart > end) break;
                end = Math.max(curEnd, end);
                i = j++;
            }
            mergedIndexRanges.add(new Pair<Integer, Integer>(start, end));
        }
        return mergedIndexRanges;
    }
}

