/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.utils;

import com.aliyun.odps.utils.StringUtils;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class UpdateChecker {
    private static final int CONNECT_TIME_OUT = 5000;
    private static final int READ_TIME_OUT = 10000;
    private static final long UPDATE_PROMPT_INTERVAL_MILLIS = 172800000L;
    private static final String updatePromptHistoryFile = ".odps_update";
    private static final String VERSION_SOURCE = "latest_version.json";
    private static final String SNAPSHOT_SUFFIX = "-snapshot";
    private String updateURL;
    private String onlineVersion;
    private String onlineDownloadURL;
    private ExecutionContext context;

    public UpdateChecker(String updateURL, ExecutionContext context) {
        this.updateURL = updateURL;
        this.context = context;
    }

    public String getOnlineDownloadURL() {
        if (StringUtils.isNullOrEmpty((String)this.onlineDownloadURL)) {
            this.getOnlineUpdateInfo();
        }
        return this.onlineDownloadURL;
    }

    public String getOnlineVersion() {
        if (StringUtils.isNullOrEmpty((String)this.onlineVersion)) {
            this.getOnlineUpdateInfo();
        }
        return this.onlineVersion;
    }

    public boolean shouldPromptUpdate() {
        return this.shouldPrompt() && this.shouldUpdate();
    }

    private void getOnlineUpdateInfo() {
        String onlineCheckURL = this.updateURL + "/" + VERSION_SOURCE;
        try {
            String inputLine;
            URL url = new URL(onlineCheckURL);
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(10000);
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            StringBuilder content = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                content.append(inputLine);
            }
            in.close();
            Map updateInfos = (Map)new GsonBuilder().disableHtmlEscaping().create().fromJson(content.toString(), Map.class);
            Map node = (Map)updateInfos.get("odpscmd");
            this.onlineVersion = (String)node.get("version");
            this.onlineDownloadURL = this.updateURL + (String)node.get("path");
        }
        catch (Exception ignore) {
            this.context.getOutputWriter().writeDebug(ignore);
        }
    }

    private boolean shouldUpdate() {
        String current = ODPSConsoleUtils.getMvnVersion();
        String onlineVersion = this.getOnlineVersion();
        if (!StringUtils.isNullOrEmpty((String)current) && !StringUtils.isNullOrEmpty((String)onlineVersion)) {
            try {
                if (ODPSConsoleUtils.compareVersion(current, onlineVersion) < 0) {
                    return true;
                }
            }
            catch (Exception e) {
                this.context.getOutputWriter().writeDebug(e);
            }
        }
        return false;
    }

    private boolean shouldPrompt() {
        try {
            String path = !StringUtils.isNullOrEmpty((String)ODPSConsoleUtils.getConfigFilePath()) ? new File(ODPSConsoleUtils.getConfigFilePath()).getParent() : System.getProperty("user.home");
            path = path + File.separator + updatePromptHistoryFile;
            File file = new File(path);
            if (file.exists()) {
                String lastPromptDate = FileUtils.readFileToString((File)file, (String)"utf-8");
                Date lastDate = ODPSConsoleUtils.DATE_FORMAT.parse(lastPromptDate);
                Date now = new Date();
                if (now.getTime() - lastDate.getTime() < 172800000L) {
                    return false;
                }
            } else {
                file.createNewFile();
            }
            FileUtils.write((File)file, (CharSequence)ODPSConsoleUtils.formatDate(new Date()), (String)"utf-8");
        }
        catch (Exception e) {
            this.context.getOutputWriter().writeDebug(e);
        }
        return true;
    }
}

