/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.utils;

public class PluginPriorityCommand
implements Comparable<PluginPriorityCommand> {
    public static final float MAX_PRIORITY = Float.POSITIVE_INFINITY;
    public static final float MIN_PRIORITY = Float.NEGATIVE_INFINITY;
    private String commandName;
    private float commandPriority;

    public PluginPriorityCommand(String commandName, float commandPriority) {
        if (!(commandPriority >= Float.NEGATIVE_INFINITY) || !(commandPriority <= Float.POSITIVE_INFINITY)) {
            throw new IllegalArgumentException("Argument illegal. Command name is: " + commandName + "; command priority is: " + commandPriority);
        }
        this.commandName = commandName;
        this.commandPriority = commandPriority;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public float getCommandPriority() {
        return this.commandPriority;
    }

    @Override
    public int compareTo(PluginPriorityCommand o1) {
        return Float.compare(o1.getCommandPriority(), this.commandPriority);
    }
}

