/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.utils;

import com.aliyun.odps.FileResource;
import com.aliyun.odps.Function;
import com.aliyun.odps.Functions;
import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Partition;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.Resource;
import com.aliyun.odps.Resources;
import com.aliyun.odps.Table;
import com.aliyun.odps.TableResource;
import com.aliyun.odps.Tables;
import com.aliyun.odps.task.SQLTask;
import com.aliyun.odps.utils.StringUtils;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.utils.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class ExportProjectUtil {
    public static void exportProject(Odps odps, String localPath, ExecutionContext sessionContext, String options) throws ODPSConsoleException, OdpsException {
        File file = new File(localPath);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!(file = new File(localPath + "/resources")).exists()) {
            file.mkdir();
        }
        StringBuilder sqlBuilder = new StringBuilder();
        StringBuilder othersBuilder = new StringBuilder();
        sqlBuilder.append((CharSequence)ExportProjectUtil.exportTables(odps, localPath, sessionContext, options));
        StringBuilder addResourceBuilder = new StringBuilder();
        StringBuilder dropResourceBuilder = new StringBuilder();
        StringBuilder createFunctionBuilder = new StringBuilder();
        StringBuilder dropFunctionBuilder = new StringBuilder();
        if (options.toUpperCase().contains("R")) {
            ExportProjectUtil.exportResources(odps, localPath, sessionContext, addResourceBuilder, dropResourceBuilder);
        }
        if (options.toUpperCase().contains("F")) {
            ExportProjectUtil.exportFunctions(odps, localPath, sessionContext, createFunctionBuilder, dropFunctionBuilder);
        }
        if (options.toUpperCase().contains("D")) {
            othersBuilder.append((CharSequence)dropFunctionBuilder);
            othersBuilder.append((CharSequence)dropResourceBuilder);
        }
        othersBuilder.append((CharSequence)addResourceBuilder);
        othersBuilder.append((CharSequence)createFunctionBuilder);
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(sqlBuilder.toString().getBytes());
            FileUtil.saveInputStreamToFile(bis, localPath + "/project_odps_sqls.dump");
            bis.close();
            bis = new ByteArrayInputStream(othersBuilder.toString().getBytes());
            FileUtil.saveInputStreamToFile(bis, localPath + "/project_odps_others.dump");
            bis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static StringBuilder exportTables(Odps odps, String localPath, ExecutionContext sessionContext, String options) throws ODPSConsoleException, OdpsException {
        Tables tables = odps.tables();
        ArrayList<Table> tableList = new ArrayList<Table>();
        for (Table table : tables) {
            tableList.add(table);
        }
        StringBuilder resultBuilder = new StringBuilder();
        sessionContext.getOutputWriter().writeResult("----Total tables:" + tableList.size() + "\r\n");
        resultBuilder.append("----Total tables:" + tableList.size() + "\r\n");
        if (options.toUpperCase().contains("D")) {
            for (Table table : tables) {
                String dropStr = "drop table if exists `" + table.getName() + "`;\r\n";
                sessionContext.getOutputWriter().writeResult(dropStr);
                resultBuilder.append(dropStr);
            }
        }
        for (Table tableInfo : tables) {
            String tableName = tableInfo.getName();
            if (tableName.startsWith("tmp_table_for_select")) continue;
            StringBuilder sqlBuilder = ExportProjectUtil.getDdlFromMeta(odps, tableInfo, options);
            if (!"".equals(sqlBuilder.toString())) {
                sessionContext.getOutputWriter().writeResult(sqlBuilder.toString());
            }
            resultBuilder.append((CharSequence)sqlBuilder);
        }
        return resultBuilder;
    }

    public static StringBuilder getDdlFromMeta(Odps odps, Table table, String options) throws OdpsException {
        StringBuilder sqlBuilder = new StringBuilder();
        if (options.toUpperCase().contains("T")) {
            sqlBuilder.append((CharSequence)ExportProjectUtil.getTableDdl(odps, table));
        }
        if (options.toUpperCase().contains("P")) {
            sqlBuilder.append((CharSequence)ExportProjectUtil.getAddPartitionDdl(table));
        }
        return sqlBuilder;
    }

    private static StringBuilder getAddPartitionDdl(Table table) throws OdpsException {
        StringBuilder addPartitionBuilder = new StringBuilder();
        if (table.getSchema().getPartitionColumns().size() == 0) {
            return addPartitionBuilder;
        }
        List partionSpecList = table.getPartitions();
        for (Partition partition : partionSpecList) {
            String partitionSpec = partition.getPartitionSpec().toString();
            if (partitionSpec.indexOf("__HIVE_DEFAULT_PARTITION__") >= 0) {
                addPartitionBuilder.append("--alter table `").append(table.getName()).append("` add IF NOT EXISTS partition(").append(partitionSpec).append(");\r\n");
                continue;
            }
            addPartitionBuilder.append("alter table `").append(table.getName()).append("` add IF NOT EXISTS partition(").append(partitionSpec).append(");\r\n");
        }
        return addPartitionBuilder;
    }

    private static StringBuilder getTableDdl(Odps odps, Table table) throws OdpsException {
        StringBuilder sqlBuilder = new StringBuilder();
        if (table.isVirtualView()) {
            String viewText = table.getViewText().replaceAll("\n", " ");
            sqlBuilder.append("drop view if exists `").append(table.getName()).append("`;\r\n");
            sqlBuilder.append("create view IF NOT EXISTS `").append(table.getName()).append("` as ").append(viewText).append(";\r\n");
            return sqlBuilder;
        }
        String taskName = "show_create_table_sql_task";
        Instance instance = SQLTask.run((Odps)odps, (String)odps.getDefaultProject(), (String)("show create table " + table.getName() + ";"), (String)"show_create_table_sql_task", null, null);
        instance.waitForSuccess();
        sqlBuilder.append((String)instance.getTaskResults().get(taskName));
        return sqlBuilder;
    }

    private static StringBuilder getClusterClause(Table table) {
        StringBuilder sb = new StringBuilder();
        if (table.getClusterInfo() != null) {
            Table.ClusterInfo clusterInfo = table.getClusterInfo();
            if (!CollectionUtils.isEmpty((Collection)clusterInfo.getClusterCols())) {
                String type = clusterInfo.getClusterType();
                if (!StringUtils.isNullOrEmpty((String)type) && !type.equalsIgnoreCase("HASH")) {
                    sb.append(" " + type);
                }
                sb.append(" clustered by( ");
                sb.append(StringUtils.join((Object[])clusterInfo.getClusterCols().toArray(), (String)", "));
                sb.append(" )");
            }
            if (!CollectionUtils.isEmpty((Collection)clusterInfo.getSortCols())) {
                sb.append(" sorted by( " + StringUtils.join((Object[])clusterInfo.getSortCols().toArray(), (String)", "));
                sb.append(" )");
            }
            if (clusterInfo.getBucketNum() > 0L) {
                sb.append(" into " + clusterInfo.getBucketNum() + " buckets");
            }
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exportResources(Odps odps, String localPath, ExecutionContext sessionContext, StringBuilder addResourceBuilder, StringBuilder dropResourceBuilder) throws ODPSConsoleException, OdpsException {
        Resources resourceMetaList = odps.resources();
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        for (Resource resource : resourceMetaList) {
            resourceList.add(resource);
        }
        sessionContext.getOutputWriter().writeResult("----Total resources:" + resourceList.size() + "\r\n");
        addResourceBuilder.append("----Total resources:" + resourceList.size() + "\r\n");
        for (Resource resourceMeta : resourceList) {
            Resource.Type type = resourceMeta.getType();
            StringBuilder resourceCommandBuf = new StringBuilder();
            if (resourceMeta.getName() == null || resourceMeta.getName().equals("")) {
                addResourceBuilder.append("---Failed: no resource name---:" + type + "\r\n");
                continue;
            }
            String alias = resourceMeta.getName();
            String filePath = localPath + "/resources/" + alias;
            String filename = resourceMeta.getName();
            switch (type) {
                case FILE: {
                    int index2;
                    if (filename != null && !filename.trim().equals("")) {
                        int index1 = filename.lastIndexOf("/");
                        index2 = filename.lastIndexOf("\\");
                        filePath = filePath + "_" + filename.substring((index1 > index2 ? index1 : index2) + 1);
                    }
                    resourceCommandBuf.append("add file ").append(filePath).append(" as ").append(alias);
                    break;
                }
                case ARCHIVE: {
                    int index2;
                    if (filename != null && !filename.trim().equals("")) {
                        int index1 = filename.lastIndexOf("/");
                        index2 = filename.lastIndexOf("\\");
                        filePath = filePath + "_" + filename.substring((index1 > index2 ? index1 : index2) + 1);
                    }
                    resourceCommandBuf.append("add archive ").append(filePath).append(" as ").append(alias);
                    break;
                }
                case TABLE: {
                    TableResource tableResourceMeta = (TableResource)odps.resources().get(resourceMeta.getName());
                    resourceCommandBuf.append("add table ");
                    resourceCommandBuf.append(tableResourceMeta.getSourceTable().getName());
                    PartitionSpec partitionSpec = tableResourceMeta.getSourceTablePartition();
                    if (partitionSpec != null) {
                        resourceCommandBuf.append(" partition(").append(partitionSpec.toString()).append(")");
                    }
                    resourceCommandBuf.append(" as ").append(alias);
                    break;
                }
                case PY: {
                    resourceCommandBuf.append("add py ").append(filePath);
                    break;
                }
                case JAR: {
                    resourceCommandBuf.append("add jar ").append(filePath);
                    break;
                }
                default: {
                    throw new ODPSConsoleException("Invalid resource type : " + type.toString());
                }
            }
            String comment = resourceMeta.getComment();
            if (comment == null || comment.trim().equals("")) {
                resourceCommandBuf.append(";\r\n");
            } else {
                resourceCommandBuf.append(" comment ").append(comment).append(";\r\n");
            }
            boolean resourceExist = true;
            if (!resourceMeta.getType().equals((Object)Resource.Type.TABLE)) {
                try {
                    FileResource fileResource = (FileResource)resourceMeta;
                    InputStream inputStream = odps.resources().getResourceAsStream(fileResource.getProject(), fileResource.getName());
                    try {
                        FileUtil.saveInputStreamToFile(inputStream, filePath);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (Exception e) {
                    resourceExist = false;
                    sessionContext.getOutputWriter().writeResult("----Failed: can't find resource:" + resourceMeta.getName() + "\r\n");
                    addResourceBuilder.append("----Failed: can't find resource:" + resourceMeta.getName() + "\r\n");
                    e.printStackTrace();
                }
            }
            if (!resourceExist) continue;
            sessionContext.getOutputWriter().writeResult("drop resource " + alias + ";\r\n");
            dropResourceBuilder.append("drop resource " + alias + ";\r\n");
            if (!"".equals(resourceCommandBuf.toString())) {
                sessionContext.getOutputWriter().writeResult(resourceCommandBuf.toString());
            }
            addResourceBuilder.append((CharSequence)resourceCommandBuf);
        }
    }

    private static void exportFunctions(Odps odps, String localPath, ExecutionContext sessionContext, StringBuilder createFunctionBuilder, StringBuilder dropFunctionBuilder) throws ODPSConsoleException, OdpsException {
        Functions functions = odps.functions();
        ArrayList<Function> functionList = new ArrayList<Function>();
        for (Function function : functions) {
            functionList.add(function);
        }
        sessionContext.getOutputWriter().writeResult("----Total functions:" + functionList.size() + "\r\n");
        createFunctionBuilder.append("----Total functions:" + functionList.size() + "\r\n");
        for (Function function : functionList) {
            StringBuilder functionCommandBuf = new StringBuilder();
            functionCommandBuf.append("create function ").append(function.getName()).append(" as '").append(function.getClassPath()).append("' using '");
            Iterator it = function.getResources().iterator();
            while (it.hasNext()) {
                Resource resStr = (Resource)it.next();
                functionCommandBuf.append(resStr.getName());
                if (!it.hasNext()) continue;
                functionCommandBuf.append(",");
            }
            functionCommandBuf.append("';\r\n");
            sessionContext.getOutputWriter().writeResult("drop function " + function.getName() + ";\r\n");
            dropFunctionBuilder.append("drop function " + function.getName() + ";\r\n");
            if (!"".equals(functionCommandBuf.toString())) {
                sessionContext.getOutputWriter().writeResult(functionCommandBuf.toString());
            }
            createFunctionBuilder.append((CharSequence)functionCommandBuf);
        }
    }
}

