/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.utils;

import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.utils.CommandWithOptionP;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class Coordinate {
    private String projectName;
    private String schemaName;
    private String objectName;
    private String partitionSpec;
    private String[] coordinate;
    private CoordinateType type;
    private int len;
    public static final Pattern TABLE_PATTERN = Pattern.compile("\\s*((?<table>[\\w.]+)(\\s*|(\\s+PARTITION\\s*\\((?<partition>.*)\\)))\\s*)");
    public static final Pattern PUB_TABLE_PATTERN = Pattern.compile("\\s*((?<table>[\\w.]+)(\\s*|(\\s*\\((?<partition>.*)\\)))\\s*)", 2);
    public static final String TABLE_GROUP = "table";
    public static final String PARTITION_GROUP = "partition";

    public Coordinate(String[] coordinate, CoordinateType type) throws ODPSConsoleException {
        this(coordinate, type, null);
    }

    public Coordinate(String[] coordinate, CoordinateType type, String partitionSpec) throws ODPSConsoleException {
        this.coordinate = coordinate;
        this.type = type;
        this.len = coordinate.length;
        if (!this.checkLen()) {
            throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. ");
        }
        this.partitionSpec = partitionSpec;
    }

    private boolean checkLen() {
        if (CoordinateType.AB.equals((Object)this.type)) {
            return this.len >= 0 && this.len <= 2;
        }
        return this.len >= 0 && this.len <= 3;
    }

    public Coordinate(String project, String schema, String object, String partitionSpec) {
        this.projectName = project;
        this.schemaName = schema;
        this.objectName = object;
        this.partitionSpec = partitionSpec;
        this.type = CoordinateType.FINAL;
    }

    public void interpretByCtx(ExecutionContext ctx) throws ODPSConsoleException {
        if (CoordinateType.AB.equals((Object)this.type)) {
            this.interpretAB(ctx);
        } else if (CoordinateType.ABC.equals((Object)this.type)) {
            this.interpretABC(ctx);
        } else if (CoordinateType.FINAL.equals((Object)this.type)) {
            return;
        }
    }

    private void interpretAB(ExecutionContext ctx) throws ODPSConsoleException {
        if (this.len == 0) {
            this.projectName = ODPSConsoleUtils.getDefaultProject(ctx);
            this.schemaName = ODPSConsoleUtils.getDefaultSchema(ctx);
        } else if (this.len == 1) {
            if (ctx.isProjectMode()) {
                this.projectName = this.coordinate[0];
                this.schemaName = null;
            } else {
                this.projectName = ODPSConsoleUtils.getDefaultProject(ctx);
                this.schemaName = this.coordinate[0];
            }
        } else if (this.len == 2) {
            this.projectName = this.coordinate[0];
            this.schemaName = this.coordinate[1];
        }
        ctx.getOutputWriter().writeDebug(this.projectName + "." + this.schemaName);
    }

    private void interpretABC(ExecutionContext ctx) throws ODPSConsoleException {
        if (this.coordinate.length == 1) {
            this.projectName = ODPSConsoleUtils.getDefaultProject(ctx);
            this.schemaName = ODPSConsoleUtils.getDefaultSchema(ctx);
            this.objectName = this.coordinate[0];
        } else if (this.coordinate.length == 2) {
            if (ctx.isProjectMode()) {
                this.projectName = this.coordinate[0];
                this.schemaName = ODPSConsoleUtils.getDefaultSchema(ctx);
            } else {
                this.projectName = ODPSConsoleUtils.getDefaultProject(ctx);
                this.schemaName = this.coordinate[0];
            }
            this.objectName = this.coordinate[1];
        } else if (this.coordinate.length == 3) {
            if (ctx.isProjectMode()) {
                throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. set odps.namespace.schema=true if you want to use <project.schema.object> syntax.");
            }
            this.projectName = this.coordinate[0];
            this.schemaName = this.coordinate[1];
            this.objectName = this.coordinate[2];
        }
        ctx.getOutputWriter().writeDebug(this.projectName + "." + this.schemaName + "." + this.objectName);
    }

    public void setPartitionSpec(String partitionSpec) {
        this.partitionSpec = partitionSpec;
    }

    public void setProject(String project) {
        this.projectName = project;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getDisplaySchemaName() {
        if (StringUtils.isBlank((String)this.schemaName)) {
            return "default";
        }
        return this.schemaName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getPartitionSpec() {
        return this.partitionSpec;
    }

    public static Coordinate getCoordinateOptionP(String project, String object) throws ODPSConsoleException {
        if (StringUtils.isBlank((String)project)) {
            return Coordinate.getCoordinateABC(object);
        }
        return new Coordinate(project, null, object, null);
    }

    public static Coordinate getCoordinateAB(String listCoordinate) throws ODPSConsoleException {
        String[] parts = new String[]{};
        if (!com.aliyun.odps.utils.StringUtils.isNullOrEmpty((String)listCoordinate)) {
            for (String p : parts = listCoordinate.split("\\.")) {
                if (!com.aliyun.odps.utils.StringUtils.isBlank((String)p)) continue;
                throw new ODPSConsoleException("Illegal list coordinate: " + listCoordinate);
            }
        }
        return new Coordinate(parts, CoordinateType.AB);
    }

    public static Coordinate getCoordinateABC(String cmd) throws ODPSConsoleException {
        return Coordinate.getCoordinateABC(cmd, ".");
    }

    public static Coordinate getCoordinateABC(String cmd, String sp) throws ODPSConsoleException {
        if (com.aliyun.odps.utils.StringUtils.isNullOrEmpty((String)(cmd = cmd.trim()))) {
            throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help.  Empty coordinate is not allowed");
        }
        if (cmd.startsWith(sp) || cmd.endsWith(sp) || cmd.contains(sp + sp)) {
            throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help.  Illegal coordinate: " + cmd);
        }
        if (sp == ".") {
            sp = "\\.";
        }
        String[] parts = cmd.split(sp);
        return new Coordinate(parts, CoordinateType.ABC);
    }

    public static List<Coordinate> getCoordinateRes(List<String> resList) throws ODPSConsoleException {
        ArrayList<Coordinate> list = new ArrayList<Coordinate>();
        for (String res : resList) {
            String[] pureItems;
            String[] items = res.split("/");
            if (items.length == 1) {
                list.add(new Coordinate(items, CoordinateType.ABC));
                continue;
            }
            if (items.length == 3) {
                pureItems = new String[]{items[0], items[2]};
                list.add(new Coordinate(pureItems, CoordinateType.ABC));
                continue;
            }
            if (items.length != 5) continue;
            pureItems = new String[]{items[0], items[2], items[4]};
            list.add(new Coordinate(pureItems, CoordinateType.ABC));
        }
        return list;
    }

    public static Coordinate getTableCoordinate(Matcher m, ExecutionContext ctx) throws ODPSConsoleException {
        String table = m.group(TABLE_GROUP);
        String partitionSpec = m.group(PARTITION_GROUP);
        Coordinate coordinate = Coordinate.getCoordinateABC(table);
        coordinate.setPartitionSpec(partitionSpec);
        return coordinate;
    }

    public static Coordinate getPubTableCoordinate(String cmdTxt, ExecutionContext ctx, boolean supportABC) throws Exception {
        CommandWithOptionP cmd = new CommandWithOptionP(cmdTxt);
        String project = cmd.getProjectValue();
        cmdTxt = cmd.getCmd();
        Matcher m = PUB_TABLE_PATTERN.matcher(cmdTxt);
        boolean match = m.matches();
        if (!match) {
            throw new Exception("Invalid syntax");
        }
        String table = m.group(TABLE_GROUP);
        if (!supportABC && table.contains(".")) {
            throw new Exception("Legacy cmd not support project.schema.object grammar");
        }
        String partitionSpec = m.group(PARTITION_GROUP);
        Coordinate coordinate = Coordinate.getCoordinateOptionP(project, table);
        coordinate.setPartitionSpec(partitionSpec);
        return coordinate;
    }

    public String toString() {
        return "Coordinate(" + this.projectName + "/" + this.schemaName + "/" + this.objectName + "/" + this.partitionSpec + ")";
    }

    public static enum CoordinateType {
        ABC,
        AB,
        FINAL;

    }
}

