/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.utils;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.OdpsHooks;
import com.aliyun.odps.account.Account;
import com.aliyun.odps.account.AliyunAccount;
import com.aliyun.odps.account.AppAccount;
import com.aliyun.odps.account.StsAccount;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.utils.StringUtils;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;

public class ConnectionCreator {
    private Account getAccount(ExecutionContext context) throws ODPSConsoleException {
        Account.AccountProvider accountProvider = context.getAccountProvider();
        switch (accountProvider) {
            case ALIYUN: {
                return new AliyunAccount(context.getAccessId(), context.getAccessKey());
            }
            case STS: {
                return new StsAccount(context.getAccessId(), context.getAccessKey(), context.getStsToken());
            }
        }
        throw new ODPSConsoleException("unsupport account provider:" + accountProvider);
    }

    private AppAccount getAppAccount(ExecutionContext context) {
        String appAccessId = context.getAppAccessId();
        String appAccessKey = context.getAppAccessKey();
        if (!StringUtils.isNullOrEmpty((String)appAccessId) && !StringUtils.isNullOrEmpty((String)appAccessKey)) {
            return new AppAccount((Account)new AliyunAccount(context.getAppAccessId(), context.getAppAccessKey()));
        }
        return null;
    }

    public Odps create(ExecutionContext context) throws ODPSConsoleException {
        if (context == null) {
            throw new ODPSConsoleException("ExecutionContext not be set! ");
        }
        if (context.getEndpoint() == null) {
            throw new ODPSConsoleException("pls set endpoint.");
        }
        String projectName = context.getProjectName();
        Account account = this.getAccount(context);
        AppAccount appAccount = this.getAppAccount(context);
        Odps odps = new Odps(account, appAccount);
        odps.setEndpoint(context.getEndpoint());
        if (StringUtils.isNullOrEmpty((String)projectName)) {
            odps.setDefaultProject(null);
        } else {
            odps.setDefaultProject(projectName);
        }
        odps.setUserAgent(ODPSConsoleUtils.getUserAgent());
        if (!context.isHttpsCheck()) {
            odps.getRestClient().setIgnoreCerts(true);
        }
        if (context.getReadTimeout() != 0) {
            odps.getRestClient().setReadTimeout(context.getReadTimeout());
        }
        if (context.getConnectTimeout() != 0) {
            odps.getRestClient().setConnectTimeout(context.getConnectTimeout());
        }
        odps.setLogViewHost(context.getLogViewHost());
        odps.getRestClient().setRetryLogger((RestClient.RetryLogger)new OdpsRetryLogger());
        odps.instances().setDefaultRunningCluster(context.getRunningCluster());
        OdpsHooks.getRegisteredHooks().clear();
        String hookString = context.getOdpsHooks();
        if (!StringUtils.isNullOrEmpty((String)hookString)) {
            String[] hooks = hookString.split(",");
            try {
                for (String hook : hooks) {
                    Class<?> hookClass = Class.forName(hook);
                    OdpsHooks.registerHook(hookClass);
                }
            }
            catch (ClassNotFoundException e) {
                throw new ODPSConsoleException("ClassNotFound : " + e.getMessage(), e);
            }
        }
        return odps;
    }

    public static class OdpsRetryLogger
    extends RestClient.RetryLogger {
        public void onRetryLog(Throwable e, long retryCount, long sleepTime) {
            String requestId;
            if (e != null && e instanceof OdpsException && (requestId = ((OdpsException)e).getRequestId()) != null) {
                System.err.println(String.format("Warning: ODPS request failed, requestID:%s, retryCount:%d, will retry in %d seconds.", requestId, retryCount, sleepTime));
                return;
            }
            System.err.println(String.format("Warning: ODPS request failed:%s, retryCount:%d, will retry in %d seconds.", e.getMessage(), retryCount, sleepTime));
        }
    }
}

