/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.output;

import com.aliyun.odps.Instance;
import com.aliyun.odps.InstanceFilter;
import com.aliyun.odps.Job;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.OdpsHooks;
import com.aliyun.odps.Task;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.util.DateUtils;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.output.Options;
import com.aliyun.openservices.odps.console.output.state.InstanceCreated;
import com.aliyun.openservices.odps.console.output.state.InstanceStateContext;
import com.aliyun.openservices.odps.console.output.state.InstanceTerminated;
import com.aliyun.openservices.odps.console.utils.CodingUtils;
import com.aliyun.openservices.odps.console.utils.statemachine.DefaultStateManager;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.jline.reader.UserInterruptException;

public class InstanceRunner {
    private ExecutionContext context;
    private Odps odps;
    private List<Task> tasks;
    private List<String> result;
    private Options options;
    private Instance instance;
    private InstanceStateContext instanceStateContext;

    public Instance getInstance() {
        return this.instance;
    }

    public InstanceRunner(Odps odps, Task task, ExecutionContext context) {
        this(odps, Arrays.asList(task), context);
    }

    public InstanceRunner(Odps odps, Instance instance, ExecutionContext context) throws OdpsException {
        this(odps, instance, instance.getTasks(), context);
    }

    public InstanceRunner(Odps odps, List<Task> tasks, ExecutionContext context) {
        this(odps, null, tasks, context);
    }

    private InstanceRunner(Odps odps, Instance instance, List<Task> tasks, ExecutionContext context) {
        CodingUtils.assertParameterNotNull(odps, "odps");
        if (tasks == null || tasks.size() == 0) {
            throw new IllegalArgumentException("tasks");
        }
        this.instance = instance;
        this.odps = odps;
        this.tasks = tasks;
        this.options = new Options(50, 5, context.getPriority());
        this.context = context;
    }

    public Instance submit() throws OdpsException {
        this.instance = this.submitWithRetry();
        return this.instance;
    }

    private Instance submitWithRetry() throws OdpsException {
        Job job = new Job();
        String guid = UUID.randomUUID().toString();
        for (Task task : this.tasks) {
            task.setProperty("guid", guid);
            job.addTask(task);
        }
        job.setPriority(this.options.getPriority());
        job.setRunningCluster(this.context.getRunningCluster());
        try {
            this.instance = this.odps.instances().create(job, this.context.isJobTryWait());
            return this.instance;
        }
        catch (OdpsException e) {
            if (!this.isRetry(e)) {
                throw e;
            }
            try {
                this.instance = this.retry(job, guid);
            }
            catch (Exception e1) {
                throw new OdpsException("\u65e0\u6cd5\u83b7\u53d6ID\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002[" + e1.getMessage() + "]", (Throwable)e1);
            }
            return this.instance;
        }
    }

    private boolean isRetry(OdpsException e) {
        if (e.getCause() != null && e.getCause() instanceof IOException) {
            return true;
        }
        String[] errorCodes = new String[]{"ODPS-0430055", "ODPS_0410077", "ODPS_0410065"};
        String errorMsg = e.getMessage();
        for (String ec : errorCodes) {
            if (errorMsg == null || errorMsg.indexOf(ec) < 0) continue;
            return true;
        }
        return false;
    }

    private Instance retry(Job job, String guid) throws Exception {
        Odps odps = this.odps.clone();
        odps.getRestClient().setRetryTimes(0);
        Response response = odps.getRestClient().request("/projects/" + odps.getDefaultProject(), "GET", null, null, null);
        Date sDate = DateUtils.parseRfc822Date((String)response.getHeader("Date"));
        Date fromDate = new Date(sDate.getTime() - 300000L);
        Date toDate = new Date(sDate.getTime() + 10000L);
        InstanceFilter filter = new InstanceFilter();
        filter.setFromTime(fromDate);
        filter.setEndTime(toDate);
        Iterator iterator = odps.instances().iterator(filter);
        while (iterator.hasNext()) {
            Instance instance = (Instance)iterator.next();
            for (Task task : instance.getTasks()) {
                if (!guid.equals(task.getProperties().get("guid"))) continue;
                if (OdpsHooks.isEnabled()) {
                    OdpsHooks hooks = new OdpsHooks();
                    instance.setOdpsHooks(hooks);
                    hooks.onInstanceCreated(instance, this.odps);
                }
                return instance;
            }
        }
        return odps.instances().create(job);
    }

    public void waitForCompletion() throws OdpsException {
        if (this.instance == null) {
            this.submit();
        }
        this.instanceStateContext = new InstanceStateContext(this.odps, this.instance, this.context);
        DefaultStateManager<InstanceStateContext> instanceStateManager = new DefaultStateManager<InstanceStateContext>();
        if (this.instance.isSync()) {
            this.instanceStateContext.printInstanceId();
            this.instance.getStatus();
            instanceStateManager.start(this.instanceStateContext, new InstanceTerminated());
        } else {
            try {
                instanceStateManager.start(this.instanceStateContext, new InstanceCreated());
            }
            catch (UserInterruptException e) {
                this.context.getOutputWriter().writeError("Instance running background.");
                this.context.getOutputWriter().writeError("Use 'kill " + this.instance.getId() + "' to stop this instance.");
                this.context.getOutputWriter().writeError("Use 'wait " + this.instance.getId() + "' to get details of this instance.");
                throw e;
            }
        }
    }

    public void printLogview() throws OdpsException {
        this.instanceStateContext = new InstanceStateContext(this.odps, this.instance, this.context);
        this.instanceStateContext.printInstanceId();
        this.instanceStateContext.printLogview();
    }

    public InstanceStateContext getInstanceStateContext() throws OdpsException {
        return new InstanceStateContext(this.odps, this.instance, this.context);
    }

    public Iterator<String> getResult() throws OdpsException {
        if (this.instanceStateContext != null) {
            return this.instanceStateContext.getResult();
        }
        return null;
    }
}

