/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.commands;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.account.Account;
import com.aliyun.odps.utils.StringUtils;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import java.util.List;

public class KonfigFromSysEnvCommand
extends AbstractCommand {
    public static final String OPTION_KONFIGFROMSYSENV = "-K";
    public static final String OPTION_KONFIGFROMSYSENV_LONG = "--konfig";
    public static final String SYSENV_ACCESS_ID = "ACCESS_KEY_ID";
    public static final String SYSENV_ACCESS_KEY = "ACCESS_KEY_SECRET";
    public static final String SYSENV_SECURITY_TOKEN = "SECURITY_TOKEN";
    public static final String SYSENV_ALIBABA_CLOUD_ACCESS_ID = "ALIBABA_CLOUD_ACCESS_KEY_ID";
    public static final String SYSENV_ALIBABA_CLOUD_ACCESS_KEY = "ALIBABA_CLOUD_ACCESS_KEY_SECRET";
    public static final String SYSENV_ALIBABA_CLOUD_SECURITY_TOKEN = "ALIBABA_CLOUD_SECURITY_TOKEN";
    public static final String SYSENV_APP_ACCESS_ID = "ODPS_CFG_APP_ACCESS_KEY_ID";
    public static final String SYSENV_APP_ACCESS_KEY = "ODPS_CFG_ACCESS_KEY_SECRET";
    public static final String SYSENV_PROJECT_NAME = "ODPS_CFG_PROJECTNAME";
    public static final String SYSENV_ODPS_ENDPOINT = "ODPS_CFG_ENDPOINT";
    private String accessID = System.getenv("ACCESS_KEY_ID");
    private String accessKey;
    private String securityToken;
    private String odpsAppAccessID;
    private String odpsAppAccessKey;
    private String odpsProjectName;
    private String odpsEndpoint;

    public KonfigFromSysEnvCommand(String commandText, ExecutionContext context) {
        super(commandText, context);
        if (!StringUtils.isEmpty((String)this.accessID)) {
            this.accessKey = System.getenv(SYSENV_ACCESS_KEY);
            this.securityToken = System.getenv(SYSENV_SECURITY_TOKEN);
        } else {
            this.accessID = System.getenv(SYSENV_ALIBABA_CLOUD_ACCESS_ID);
            this.accessKey = System.getenv(SYSENV_ALIBABA_CLOUD_ACCESS_KEY);
            this.securityToken = System.getenv(SYSENV_ALIBABA_CLOUD_SECURITY_TOKEN);
        }
        this.odpsAppAccessID = System.getenv(SYSENV_APP_ACCESS_ID);
        this.odpsAppAccessKey = System.getenv(SYSENV_APP_ACCESS_KEY);
        this.odpsProjectName = System.getenv(SYSENV_PROJECT_NAME);
        this.odpsEndpoint = System.getenv(SYSENV_ODPS_ENDPOINT);
    }

    @Override
    protected void run() throws OdpsException, ODPSConsoleException {
        ExecutionContext execCtx = this.getContext();
        if (this.accessID == null || this.accessKey == null) {
            throw new ODPSConsoleException("Both ACCESS_KEY_ID and ACCESS_KEY_SECRET are required in sysenv.");
        }
        execCtx.setAccessId(this.accessID);
        execCtx.setAccessKey(this.accessKey);
        if (this.securityToken != null) {
            execCtx.setStsToken(this.securityToken);
            execCtx.setAccountProvider(Account.AccountProvider.STS);
        }
        if (this.odpsAppAccessID != null && this.odpsAppAccessKey != null) {
            execCtx.setAppAccessId(this.odpsAppAccessID);
            execCtx.setAppAccessKey(this.odpsAppAccessKey);
        }
        if (this.odpsProjectName != null) {
            execCtx.setProjectName(this.odpsProjectName);
        }
        if (this.odpsEndpoint != null) {
            execCtx.setEndpoint(this.odpsEndpoint);
        }
    }

    public static KonfigFromSysEnvCommand parse(List<String> optionList, ExecutionContext sessionContext) throws ODPSConsoleException {
        int optionPosKonfig = optionList.indexOf(OPTION_KONFIGFROMSYSENV);
        int optionPosKonfigLong = optionList.indexOf(OPTION_KONFIGFROMSYSENV_LONG);
        if (optionPosKonfig != -1 && optionList.remove(optionPosKonfig) != null || optionPosKonfigLong != -1 && optionList.remove(optionPosKonfigLong) != null) {
            return new KonfigFromSysEnvCommand(optionPosKonfig != -1 ? OPTION_KONFIGFROMSYSENV : OPTION_KONFIGFROMSYSENV_LONG, sessionContext);
        }
        return null;
    }
}

