/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.commands;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.utils.StringUtils;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import java.util.List;

public class InstancePriorityCommand
extends AbstractCommand {
    int priority = 9;

    public InstancePriorityCommand(int priority, String commandText, ExecutionContext context) {
        super(commandText, context);
        this.priority = priority;
    }

    @Override
    public void run() throws OdpsException, ODPSConsoleException {
        this.getContext().setPriority(this.priority);
        this.getContext().setPaiPriority(this.priority);
    }

    public static InstancePriorityCommand parse(List<String> optionList, ExecutionContext sessionContext) throws ODPSConsoleException {
        String instancePriorty = ODPSConsoleUtils.shiftOption(optionList, "--instance-priority");
        if (!StringUtils.isNullOrEmpty((String)instancePriorty)) {
            int priority;
            try {
                priority = Integer.parseInt(instancePriorty.trim());
            }
            catch (NumberFormatException e) {
                throw new ODPSConsoleException("priority need int value[--instance_priority=" + instancePriorty + "]");
            }
            return new InstancePriorityCommand(priority, "--instance-priority", sessionContext);
        }
        return null;
    }
}

