/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.commands;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Task;
import com.aliyun.odps.task.MergeTask;
import com.aliyun.odps.utils.StringUtils;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.MultiClusterCommandBase;
import com.aliyun.openservices.odps.console.output.DefaultOutputWriter;
import com.aliyun.openservices.odps.console.utils.QueryUtil;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jline.reader.UserInterruptException;

public class FreezeCommand
extends MultiClusterCommandBase {
    public static final String[] HELP_TAGS = new String[]{"freeze", "cold", "storage"};

    public static void printUsage(PrintStream stream) {
        stream.println("Usage: alter table <table name> (<partition spec>)? freeze");
    }

    public FreezeCommand(String commandText, ExecutionContext context) {
        super(commandText, context);
    }

    @Override
    protected void run() throws OdpsException, ODPSConsoleException {
        ExecutionContext context = this.getContext();
        DefaultOutputWriter writer = context.getOutputWriter();
        int retryTime = context.getRetryTimes();
        retryTime = retryTime > 0 ? retryTime : 1;
        while (true) {
            try {
                String taskName = "console_cold_storage_freeze_task_" + Calendar.getInstance().getTimeInMillis();
                MergeTask task = new MergeTask(taskName, this.getCommandText());
                HashMap<String, String> taskConfig = QueryUtil.getTaskConfig();
                FreezeCommand.addSetting(taskConfig, Collections.singletonMap("odps.merge.cold.storage.mode", "backup"));
                for (Map.Entry<String, String> property : taskConfig.entrySet()) {
                    task.setProperty(property.getKey(), property.getValue());
                }
                this.runJob((Task)task);
                writer.writeError("OK");
            }
            catch (UserInterruptException e) {
                throw e;
            }
            catch (Exception e) {
                if (--retryTime <= 0) {
                    throw new ODPSConsoleException(e.getMessage());
                }
                writer.writeError("retry " + retryTime);
                writer.writeDebug(StringUtils.stringifyException((Throwable)e));
                continue;
            }
            break;
        }
    }

    public static FreezeCommand parse(String commandString, ExecutionContext sessionContext) {
        String regex = "\\s*ALTER\\s+TABLE\\s+(.*)\\s+(FREEZE\\s*)$";
        Pattern p = Pattern.compile(regex, 2);
        Matcher m = p.matcher(commandString);
        if (m.find()) {
            return new FreezeCommand(m.group(1), sessionContext);
        }
        return null;
    }
}

