/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.commands;

import com.aliyun.odps.OdpsException;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import java.util.List;

public class AppLoginCommand
extends AbstractCommand {
    private static final String APP_ACCESS_ID = "--app-id";
    private static final String APP_ACCESS_KEY = "--app-key";
    private String appAccessId;
    private String appAccessKey;

    public AppLoginCommand(String appAccessId, String appAccessKey, String commandText, ExecutionContext context) {
        super(commandText, context);
        this.appAccessId = appAccessId;
        this.appAccessKey = appAccessKey;
    }

    @Override
    public void run() throws OdpsException, ODPSConsoleException {
        if (this.appAccessId != null) {
            this.getContext().setAppAccessId(this.appAccessId);
        }
        if (this.appAccessKey != null) {
            this.getContext().setAppAccessKey(this.appAccessKey);
        }
    }

    public static AppLoginCommand parse(List<String> optionList, ExecutionContext sessionContext) throws ODPSConsoleException {
        String appAccessId = ODPSConsoleUtils.shiftOption(optionList, APP_ACCESS_ID);
        String appAccessKey = ODPSConsoleUtils.shiftOption(optionList, APP_ACCESS_KEY);
        if (appAccessId != null && appAccessKey != null) {
            return new AppLoginCommand(appAccessId, appAccessKey, "--app-id--app-key", sessionContext);
        }
        return null;
    }
}

