/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.resource;

import com.aliyun.odps.Function;
import com.aliyun.odps.Odps;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.utils.Coordinate;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import java.io.PrintStream;
import java.util.Date;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ListFunctionsCommand
extends AbstractCommand {
    public static final String[] HELP_TAGS = new String[]{"list", "ls", "show", "function", "functions"};
    private static final String coordinateGroup = "coordinate";
    private static final String prefixGroup = "prefix";
    private static final Pattern PATTERN = Pattern.compile("\\s*(LS|LIST|SHOW)\\s+FUNCTIONS(\\s+(IN|FROM)\\s+(?<coordinate>[\\w.]+))?\\s*(\\s*|(\\s+LIKE\\s+'(?<prefix>\\w*)(\\*|%)'))\\s*", 2);
    private Coordinate coordinate;
    private String prefix;

    public static void printUsage(PrintStream out, ExecutionContext ctx) {
        if (ctx.isProjectMode()) {
            out.println("Usage: show functions [in/from <project name>[.<schema name>]] [like '<prefix>'];");
            out.println("Examples:");
            out.println("  show functions;");
            out.println("  show functions like 'my_%';");
            out.println("  show functions in my_project;");
            out.println("  show functions from my_project;");
            out.println("  show functions in my_project.my_schema;");
            out.println("  show functions from my_project.my_schema;");
        } else {
            out.println("Usage: show functions [in/from [<project name>.]<schema name>] [like '<prefix>'];");
            out.println("Examples:");
            out.println("  show functions;");
            out.println("  show functions like 'my_%';");
            out.println("  show functions in my_schema;");
            out.println("  show functions from my_schema;");
            out.println("  show functions in my_project.my_schema;");
            out.println("  show functions from my_project.my_schema;");
        }
    }

    public ListFunctionsCommand(Coordinate coordinate, String commandText, ExecutionContext context, String prefix) {
        super(commandText, context);
        this.coordinate = coordinate;
        this.prefix = prefix;
    }

    public void run() throws ODPSConsoleException {
        this.coordinate.interpretByCtx(this.getContext());
        String project = this.coordinate.getProjectName();
        String schema = this.coordinate.getSchemaName();
        Odps odps = this.getCurrentOdps();
        String[] headers = new String[]{"Name", "Owner", "Create Time", "Class", "Resources"};
        int[] columnPercent = new int[]{12, 20, 15, 23, 30};
        int consoleWidth = this.getContext().getConsoleWidth();
        Iterator functionIter = odps.functions().iterator(project, schema, this.prefix);
        functionIter.hasNext();
        ODPSConsoleUtils.formaterTableRow((String[])headers, (int[])columnPercent, (int)consoleWidth);
        int count = 0;
        while (functionIter.hasNext()) {
            ODPSConsoleUtils.checkThreadInterrupted();
            ++count;
            Function p = (Function)functionIter.next();
            String[] functionAttr = new String[]{p.getName(), p.getOwner(), p.getCreatedTime() == null ? " " : ODPSConsoleUtils.formatDate((Date)p.getCreatedTime()), p.getClassPath(), ""};
            for (String name : p.getResourceNames()) {
                functionAttr[4] = functionAttr[4] + name + ",";
            }
            int endIndex = functionAttr[4].lastIndexOf(",");
            if (endIndex != -1) {
                functionAttr[4] = functionAttr[4].substring(0, endIndex);
            }
            ODPSConsoleUtils.formaterTableRow((String[])functionAttr, (int[])columnPercent, (int)consoleWidth);
        }
        this.getWriter().writeError(count + " functions");
    }

    public static ListFunctionsCommand parse(String commandString, ExecutionContext sessionContext) throws ODPSConsoleException {
        Matcher matcher = PATTERN.matcher(commandString);
        if (!matcher.matches()) {
            return null;
        }
        Coordinate coordinate = Coordinate.getCoordinateAB((String)matcher.group(coordinateGroup));
        String prefixName = matcher.group(prefixGroup);
        return new ListFunctionsCommand(coordinate, commandString, sessionContext, prefixName);
    }
}

