/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.resource;

import com.aliyun.odps.NoSuchObjectException;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.utils.CommandParserUtils;
import com.aliyun.openservices.odps.console.utils.CommandWithOptionP;
import com.aliyun.openservices.odps.console.utils.Coordinate;
import java.io.PrintStream;

public class DropResourceCommand
extends AbstractCommand {
    public static final String[] HELP_TAGS = new String[]{"drop", "delete", "resource"};
    private Coordinate coordinate;

    public static void printUsage(PrintStream out, ExecutionContext ctx) {
        if (ctx.isProjectMode()) {
            out.println("Usage: drop resource [<project name>:]<resource name>");
        } else {
            out.println("Usage: drop resource [[<project name>:]<schema name>]:<resource name>");
        }
    }

    public DropResourceCommand(Coordinate coordinate, String commandText, ExecutionContext context) {
        super(commandText, context);
        this.coordinate = coordinate;
    }

    public void run() throws ODPSConsoleException, OdpsException {
        this.coordinate.interpretByCtx(this.getContext());
        String projectName = this.coordinate.getProjectName();
        String schemaName = this.coordinate.getSchemaName();
        String resourceName = this.coordinate.getObjectName();
        Odps odps = this.getCurrentOdps();
        try {
            odps.resources().delete(projectName, schemaName, resourceName);
            this.getWriter().writeError("OK");
        }
        catch (NoSuchObjectException e) {
            this.getWriter().writeError(e.getMessage());
        }
        catch (OdpsException e) {
            throw new ODPSConsoleException(e.getMessage());
        }
    }

    public static DropResourceCommand parse(String commandString, ExecutionContext sessionContext) throws ODPSConsoleException {
        Coordinate coordinate;
        boolean matchDrop;
        String[] args = CommandParserUtils.getCommandTokens((String)commandString);
        if (args.length < 3) {
            return null;
        }
        boolean matchDelete = "DELETE".equalsIgnoreCase(args[0]) && "RESOURCE".equalsIgnoreCase(args[1]);
        boolean bl = matchDrop = "DROP".equalsIgnoreCase(args[0]) && "RESOURCE".equalsIgnoreCase(args[1]);
        if (!matchDelete && !matchDrop) {
            return null;
        }
        CommandWithOptionP cmdP = new CommandWithOptionP(commandString);
        String project = null;
        String resource = null;
        if (matchDelete) {
            project = cmdP.getProjectValue();
            args = cmdP.getArgs();
        }
        if (args.length != 3) {
            throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. ");
        }
        resource = args[2];
        if (matchDelete) {
            if (resource.contains(":")) {
                throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. ");
            }
            coordinate = Coordinate.getCoordinateOptionP((String)project, (String)resource);
        } else {
            coordinate = Coordinate.getCoordinateABC((String)resource, (String)":");
        }
        return new DropResourceCommand(coordinate, commandString, sessionContext);
    }
}

