/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.resource;

import com.aliyun.odps.ArchiveResource;
import com.aliyun.odps.FileResource;
import com.aliyun.odps.JarResource;
import com.aliyun.odps.NoSuchObjectException;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsDeprecatedLogger;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.PyResource;
import com.aliyun.odps.Resource;
import com.aliyun.odps.TableResource;
import com.aliyun.odps.VolumeArchiveResource;
import com.aliyun.odps.VolumeFileResource;
import com.aliyun.odps.VolumeResource;
import com.aliyun.odps.utils.StringUtils;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.utils.Coordinate;
import com.aliyun.openservices.odps.console.utils.FileUtil;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AddResourceCommand
extends AbstractCommand {
    public static final String[] HELP_TAGS = new String[]{"add", "create", "resource"};
    String refName;
    String alias;
    String comment;
    String type;
    Coordinate tableCoordinate;
    String partitionSpec;
    String projectName;
    String schemaName;
    boolean isUpdate;
    private static final Pattern TO_PACKAGE_REGEX = Pattern.compile("\\s*ADD.*TO\\s+PACKAGE.*\\s*", 2);

    public static void printUsage(PrintStream out, ExecutionContext ctx) {
        out.println("Usage: ADD <FILE | ARCHIVE >  [AS alias] [COMMENT 'cmt'][-F];");
        out.println("       ADD TABLE <tablename> [PARTITION (SPEC)] [AS alias] [COMMENT 'cmt'][-F];");
        out.println("       ADD <PY | JAR> <localfile[.py |.jar]> [COMMENT 'cmt'][-F];");
        out.println("       ADD <VOLUMEFILE|VOLUMEARCHIVE> <filename> AS <alias> [COMMENT 'cmt'][-F];");
        if (ctx.isSchemaMode()) {
            out.println("Notice: this command can only add the resource to the current schema");
        }
    }

    public String getRefName() {
        return this.refName;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getComment() {
        return this.comment;
    }

    public String getType() {
        return this.type;
    }

    public String getPartitionSpec() {
        return this.partitionSpec;
    }

    public boolean isUpdate() {
        return this.isUpdate;
    }

    public AddResourceCommand(String commandText, ExecutionContext context) {
        super(commandText, context);
    }

    public AddResourceCommand(String commandText, ExecutionContext context, String refName, String alias, String comment, String type, String partitionSpec, boolean isUpdate, String projectName) {
        super(commandText, context);
        this.refName = refName;
        this.alias = alias;
        this.comment = comment;
        this.type = type;
        this.partitionSpec = partitionSpec;
        this.isUpdate = isUpdate;
        this.projectName = projectName;
    }

    public void run() throws OdpsException, ODPSConsoleException {
        String aliasSuffix = StringUtils.isNullOrEmpty((String)this.alias) ? this.refName.toUpperCase() : this.alias.toUpperCase();
        if (this.type.equals("PY") && !aliasSuffix.endsWith(".PY")) {
            throw new ODPSConsoleException("File name must end with py");
        }
        if (this.type.equals("JAR") && !aliasSuffix.endsWith(".JAR")) {
            throw new ODPSConsoleException("File name must end with jar");
        }
        if (!(!this.type.endsWith("ARCHIVE") || aliasSuffix.endsWith(".JAR") || aliasSuffix.endsWith(".ZIP") || aliasSuffix.endsWith(".TGZ") || aliasSuffix.endsWith(".TAR.GZ") || aliasSuffix.endsWith(".TAR") || aliasSuffix.endsWith(".WHL"))) {
            throw new ODPSConsoleException("File name(alias name) must end with .jar/.zip/.tgz/.tar.gz/.tar/.whl");
        }
        if (!StringUtils.isNullOrEmpty((String)this.partitionSpec) && StringUtils.isNullOrEmpty((String)this.alias)) {
            AddResourceCommand.throwUsageError(System.err, "pls set alias.");
        }
        Odps odps = this.getCurrentOdps();
        if (StringUtils.isNullOrEmpty((String)this.projectName)) {
            this.projectName = this.getCurrentProject();
            this.schemaName = ODPSConsoleUtils.getDefaultSchema((ExecutionContext)this.getContext());
        }
        ArchiveResource resource = null;
        Resource.Type resType = Resource.Type.valueOf((String)this.type.toUpperCase());
        switch (resType) {
            case VOLUMEFILE: 
            case VOLUMEARCHIVE: {
                this.addVolume(odps);
                break;
            }
            case ARCHIVE: {
                resource = new ArchiveResource();
                break;
            }
            case PY: {
                resource = new PyResource();
                break;
            }
            case JAR: {
                resource = new JarResource();
                break;
            }
            case FILE: {
                resource = new FileResource();
                break;
            }
            case TABLE: {
                this.addTable(odps);
            }
        }
        if (resource != null) {
            this.addFile(odps, (FileResource)resource);
        }
        if (!this.isUpdate) {
            this.getWriter().writeError("OK: Resource '" + this.alias + "' have been created.");
        } else {
            this.getWriter().writeError("OK: Resource '" + this.alias + "' have been updated.");
        }
    }

    private void addFile(Odps odps, FileResource resource) throws OdpsException, ODPSConsoleException {
        this.refName = FileUtil.expandUserHomeInPath((String)this.refName);
        File file = new File(this.refName);
        if (file.exists()) {
            if (this.alias == null || this.alias.length() == 0) {
                this.alias = file.getName();
            }
            resource.setName(this.alias);
            resource.setComment(this.comment);
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(file);
                if (!this.isUpdate) {
                    odps.resources().create(this.projectName, this.schemaName, resource, (InputStream)inputStream);
                }
                try {
                    odps.resources().update(this.projectName, this.schemaName, resource, (InputStream)inputStream);
                }
                catch (NoSuchObjectException e) {
                    inputStream.close();
                    inputStream = new FileInputStream(file);
                    odps.resources().create(this.projectName, this.schemaName, resource, (InputStream)inputStream);
                }
            }
            catch (IOException e) {
                throw new ODPSConsoleException("File upload fail", (Throwable)e);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        } else {
            throw new ODPSConsoleException("File not exist:" + this.refName);
        }
    }

    private void addTable(Odps odps) throws OdpsException, ODPSConsoleException {
        PartitionSpec spec = null;
        if (this.partitionSpec == null || this.partitionSpec.length() == 0) {
            this.partitionSpec = null;
        } else {
            spec = new PartitionSpec(this.partitionSpec);
        }
        if (this.tableCoordinate != null) {
            this.tableCoordinate.interpretByCtx(this.getContext());
            this.refName = this.getContext().isProjectMode() ? String.format("%s.%s", this.tableCoordinate.getProjectName(), this.tableCoordinate.getObjectName()) : String.format("%s.%s.%s", this.tableCoordinate.getProjectName(), this.tableCoordinate.getSchemaName() == null ? "default" : this.tableCoordinate.getSchemaName(), this.tableCoordinate.getObjectName());
        }
        TableResource resource = new TableResource(this.refName, null, spec);
        resource.setComment(this.comment);
        resource.setName(this.alias);
        if (!this.isUpdate) {
            odps.resources().create(this.projectName, this.schemaName, resource);
        } else {
            try {
                odps.resources().update(this.projectName, this.schemaName, resource);
            }
            catch (NoSuchObjectException e) {
                odps.resources().create(this.projectName, this.schemaName, resource);
            }
        }
    }

    private void addVolume(Odps odps) throws OdpsException, ODPSConsoleException {
        if ("".equals(this.alias)) {
            AddResourceCommand.throwUsageError(System.err, "pls set alias for volume file.");
        }
        String refPath = this.projectName + "/volumes" + (this.refName.startsWith("/") ? "" : "/") + this.refName;
        Resource.Type resType = Resource.Type.valueOf((String)this.type.toUpperCase());
        VolumeFileResource resource = null;
        if (resType == Resource.Type.VOLUMEFILE) {
            resource = new VolumeFileResource();
        } else if (resType == Resource.Type.VOLUMEARCHIVE) {
            resource = new VolumeArchiveResource();
        } else {
            throw new ODPSConsoleException("unsupported volume resource type: " + resType);
        }
        resource.setComment(this.comment);
        resource.setName(this.alias);
        resource.setVolumePath(refPath);
        if (this.isUpdate) {
            try {
                odps.resources().update((VolumeResource)resource);
                return;
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
        }
        odps.resources().create((VolumeResource)resource);
    }

    public static boolean isSecurityCommand(String cmd) {
        if (cmd == null || cmd.length() == 0) {
            return false;
        }
        boolean r = false;
        Matcher m = TO_PACKAGE_REGEX.matcher(cmd);
        if (m != null && m.matches()) {
            r = true;
        }
        return r;
    }

    public static AddResourceCommand parse(String commandString, ExecutionContext sessionContext) throws ODPSConsoleException {
        if (AddResourceCommand.isSecurityCommand(commandString)) {
            return null;
        }
        String oldString = commandString;
        if (commandString.toUpperCase().matches("\\s*ADD\\s+((FILE)|(PY)|(JAR)|(ARCHIVE)|(TABLE)|(VOLUMEFILE)|(VOLUMEARCHIVE))[\\s\\S]*")) {
            int commandIndex;
            commandString = commandString.replaceAll("\\s+", " ").trim();
            commandString = commandString.substring(4);
            boolean isUpdate = false;
            if (commandString.toUpperCase().endsWith(" -F")) {
                isUpdate = true;
                commandString = commandString.substring(0, commandString.length() - 2).trim();
            }
            if ((commandIndex = commandString.indexOf(" ")) == -1) {
                AddResourceCommand.throwUsageError(System.err, "bad command");
            }
            String command = commandString.substring(0, commandIndex).trim().toUpperCase();
            int fileIndex = (commandString = commandString.substring(commandIndex).trim()).indexOf(" ");
            String refName = fileIndex == -1 ? commandString : commandString.substring(0, fileIndex);
            commandString = commandString.substring(refName.length()).trim();
            String partitionSpec = "";
            if ("TABLE".equals(command) && commandString.toUpperCase().indexOf("PARTITION") == 0 && commandString.indexOf("(") > 0 && commandString.indexOf(")") > 0) {
                partitionSpec = commandString.substring(commandString.indexOf("(") + 1, commandString.indexOf(")"));
                commandString = commandString.substring(commandString.indexOf(")") + 1).trim();
            }
            int asIndex = commandString.toUpperCase().indexOf("AS ");
            String alias = "";
            if (asIndex == 0) {
                int asIndexSpace = (commandString = commandString.substring(2).trim()).indexOf(" ");
                alias = asIndexSpace > 0 ? commandString.substring(0, asIndexSpace) : commandString;
            }
            commandString = commandString.substring(alias.length()).trim();
            int commentIndex = commandString.toUpperCase().indexOf("COMMENT ");
            String comment = "";
            if (commentIndex == 0) {
                comment = commandString = commandString.substring("COMMENT ".length()).trim();
            }
            if (!(commandString = commandString.substring(comment.length()).trim()).isEmpty()) {
                String warningName = "AddResourceCommandAsMissing";
                Long count = (Long)OdpsDeprecatedLogger.getDeprecatedCalls().get(warningName);
                count = count == null ? Long.valueOf(1L) : Long.valueOf(count + 1L);
                OdpsDeprecatedLogger.getDeprecatedCalls().put(warningName, count);
                System.err.println("Warning: ignore part \"" + commandString + "\" in command, maybe 'AS' is missing");
            }
            if ("TABLE".equals(command) && StringUtils.isNullOrEmpty((String)alias)) {
                alias = refName;
            }
            AddResourceCommand addResourceCommand = new AddResourceCommand(oldString, sessionContext);
            addResourceCommand.type = command;
            addResourceCommand.refName = refName.replaceAll("'", "").replaceAll("\"", "");
            if ("TABLE".equals(command)) {
                addResourceCommand.tableCoordinate = Coordinate.getCoordinateABC((String)addResourceCommand.refName);
            }
            addResourceCommand.alias = alias.replaceAll("'", "").replaceAll("\"", "");
            addResourceCommand.comment = comment;
            addResourceCommand.partitionSpec = partitionSpec.replaceAll(" ", "");
            addResourceCommand.isUpdate = isUpdate;
            return addResourceCommand;
        }
        return null;
    }

    private static void throwUsageError(PrintStream out, String msg) throws ODPSConsoleException {
        AddResourceCommand.printUsage((PrintStream)out);
        throw new ODPSConsoleException(msg);
    }
}

