/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.io;

import com.aliyun.odps.io.WritableComparable;
import com.aliyun.odps.io.WritableComparator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;

public class TimestampNtzWritable
implements WritableComparable<TimestampNtzWritable> {
    private long seconds = 0L;
    private int nanos = 0;

    public TimestampNtzWritable() {
    }

    public TimestampNtzWritable(LocalDateTime value) {
        this.set(value);
    }

    public TimestampNtzWritable(long seconds, int nanos) {
        this.set(seconds, nanos);
    }

    public LocalDateTime get() {
        return LocalDateTime.ofEpochSecond(this.seconds, this.nanos, ZoneOffset.UTC);
    }

    public long getSeconds() {
        return this.seconds;
    }

    public int getNanos() {
        return this.nanos;
    }

    public void set(long seconds, int nanos) {
        ChronoField.NANO_OF_SECOND.checkValidValue(nanos);
        this.seconds = seconds;
        this.nanos = nanos;
    }

    public void set(LocalDateTime ld) {
        Instant instant = ld.atOffset(ZoneOffset.UTC).toInstant();
        this.set(instant.getEpochSecond(), instant.getNano());
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.seconds = in.readLong();
        this.nanos = in.readInt();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeLong(this.seconds);
        out.writeInt(this.nanos);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimestampNtzWritable that = (TimestampNtzWritable)o;
        if (this.seconds != that.seconds) {
            return false;
        }
        return this.nanos == that.nanos;
    }

    public int hashCode() {
        int result = (int)(this.seconds ^ this.seconds >>> 32);
        result = 31 * result + this.nanos;
        return result;
    }

    @Override
    public int compareTo(TimestampNtzWritable o) {
        if (this.seconds == o.seconds) {
            return this.nanos < o.nanos ? -2 : (this.nanos == o.nanos ? 0 : 2);
        }
        return this.seconds < o.seconds ? -1 : 1;
    }

    static {
        WritableComparator.define(TimestampNtzWritable.class, new Comparator());
    }

    public static class DecreasingComparator
    extends Comparator {
        @Override
        public int compare(WritableComparable a, WritableComparable b) {
            return -super.compare(a, b);
        }

        @Override
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            return -super.compare(b1, s1, l1, b2, s2, l2);
        }
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(TimestampNtzWritable.class);
        }

        @Override
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            long thatValue;
            long thisValue = Comparator.readLong(b1, s1);
            if (thisValue == (thatValue = Comparator.readLong(b2, s2))) {
                int thatNano;
                int thisNano = Comparator.readInt(b1, s1 + 8);
                return thisNano < (thatNano = Comparator.readInt(b2, s2 + 8)) ? -2 : (thisNano == thatNano ? 0 : 2);
            }
            return thisValue < thatValue ? -1 : 1;
        }
    }
}

