/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.io;

import com.aliyun.odps.io.AbstractMapWritable;
import com.aliyun.odps.io.NullWritable;
import com.aliyun.odps.io.Writable;
import com.aliyun.odps.utils.ReflectionUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class MapWritable
extends AbstractMapWritable
implements Map<Writable, Writable> {
    private Map<Writable, Writable> instance = new LinkedHashMap<Writable, Writable>();

    public MapWritable() {
    }

    public MapWritable(MapWritable other) {
        this();
        this.copy(other);
    }

    @Override
    public void clear() {
        this.instance.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.instance.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.instance.containsValue(value);
    }

    @Override
    public Set<Map.Entry<Writable, Writable>> entrySet() {
        return this.instance.entrySet();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MapWritable) {
            MapWritable map = (MapWritable)obj;
            if (this.size() != map.size()) {
                return false;
            }
            return this.entrySet().equals(map.entrySet());
        }
        return false;
    }

    @Override
    public Writable get(Object key) {
        return this.instance.get(key);
    }

    @Override
    public int hashCode() {
        return 1 + this.instance.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.instance.isEmpty();
    }

    @Override
    public Set<Writable> keySet() {
        return this.instance.keySet();
    }

    @Override
    public Writable put(Writable key, Writable value) {
        if (key != null) {
            this.addToMap(key.getClass());
        }
        if (value != null) {
            this.addToMap(value.getClass());
        }
        return this.instance.put(key, value);
    }

    @Override
    public void putAll(Map<? extends Writable, ? extends Writable> t) {
        for (Map.Entry<? extends Writable, ? extends Writable> e : t.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public Writable remove(Object key) {
        return this.instance.remove(key);
    }

    @Override
    public int size() {
        return this.instance.size();
    }

    @Override
    public Collection<Writable> values() {
        return this.instance.values();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.instance.size());
        for (Map.Entry<Writable, Writable> e : this.instance.entrySet()) {
            Writable key = e.getKey();
            if (key == null) {
                out.writeByte(this.getId(NullWritable.class));
            } else {
                out.writeByte(this.getId(key.getClass()));
                key.write(out);
            }
            Writable value = e.getValue();
            if (value == null) {
                out.writeByte(this.getId(NullWritable.class));
                continue;
            }
            out.writeByte(this.getId(value.getClass()));
            value.write(out);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.instance.clear();
        int entries = in.readInt();
        for (int i = 0; i < entries; ++i) {
            Class keyClass = this.getClass(in.readByte());
            Writable key = null;
            if (keyClass != NullWritable.class) {
                key = (Writable)ReflectionUtils.newInstance(keyClass, this.getConf());
                key.readFields(in);
            }
            Class valueClass = this.getClass(in.readByte());
            Writable value = null;
            if (valueClass != NullWritable.class) {
                value = (Writable)ReflectionUtils.newInstance(valueClass, this.getConf());
                value.readFields(in);
            }
            this.instance.put(key, value);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        for (Map.Entry<Writable, Writable> entry : this.entrySet()) {
            sb.append("{");
            sb.append(entry.getKey().toString());
            sb.append(":");
            sb.append(entry.getValue().toString());
            sb.append("}");
        }
        sb.append("]");
        return sb.toString();
    }
}

