/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.OdpsType;
import com.aliyun.odps.data.GenerateExpression;
import com.aliyun.odps.type.ArrayTypeInfo;
import com.aliyun.odps.type.MapTypeInfo;
import com.aliyun.odps.type.PrimitiveTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.type.TypeInfoFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class Column
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private OdpsType type;
    private TypeInfo typeInfo;
    private String comment;
    private String label;
    private String defaultValue = null;
    private boolean isNullable = true;
    private boolean hasDefaultValue = false;
    private List<OdpsType> genericOdpsTypeList;
    private List<String> extendedLabels;
    private GenerateExpression generateExpression;

    public Column(String name, TypeInfo typeInfo) {
        this(name, typeInfo, null);
    }

    public Column(String name, TypeInfo typeInfo, String comment) {
        this(name, typeInfo, comment, null);
    }

    public Column(String name, TypeInfo typeInfo, String comment, String label) {
        this(name, typeInfo, comment, label, null);
    }

    public Column(String name, TypeInfo typeInfo, String comment, String label, List<String> extendedLabels) {
        this.name = name;
        this.comment = comment;
        this.typeInfo = typeInfo;
        this.label = label;
        this.type = typeInfo.getOdpsType();
        this.extendedLabels = extendedLabels;
        this.initGenericOdpsTypeList();
    }

    public static ColumnBuilder newBuilder(String name, TypeInfo typeInfo) {
        return new ColumnBuilder(name, typeInfo);
    }

    public Column(ColumnBuilder columnBuilder) {
        this(columnBuilder.name, columnBuilder.typeInfo, columnBuilder.comment, columnBuilder.label, columnBuilder.extendedLabels);
        this.isNullable = !columnBuilder.notNull;
        this.generateExpression = columnBuilder.generateExpression;
    }

    @Deprecated
    public Column(String name, OdpsType type) {
        this(name, type, null);
    }

    @Deprecated
    public Column(String name, OdpsType type, String comment) {
        this(name, type, comment, (String)null, null);
    }

    @Deprecated
    public Column(String name, OdpsType type, String comment, String label, List<OdpsType> genericOdpsTypeList) {
        this.name = name;
        this.comment = comment;
        this.label = label;
        this.type = type;
        this.genericOdpsTypeList = genericOdpsTypeList;
        this.initTypeInfo();
    }

    private void initGenericOdpsTypeList() {
        switch (this.type) {
            case ARRAY: {
                this.genericOdpsTypeList = new ArrayList<OdpsType>();
                this.genericOdpsTypeList.add(((ArrayTypeInfo)this.typeInfo).getElementTypeInfo().getOdpsType());
                break;
            }
            case MAP: {
                this.genericOdpsTypeList = new ArrayList<OdpsType>();
                MapTypeInfo mapTypeInfo = (MapTypeInfo)this.typeInfo;
                this.genericOdpsTypeList.add(mapTypeInfo.getKeyTypeInfo().getOdpsType());
                this.genericOdpsTypeList.add(mapTypeInfo.getValueTypeInfo().getOdpsType());
                break;
            }
        }
    }

    private void initTypeInfo() {
        switch (this.type) {
            case ARRAY: {
                this.initArrayTypeInfo();
                break;
            }
            case MAP: {
                this.initMapTypeInfo();
                break;
            }
            case VARCHAR: {
                throw new IllegalArgumentException("The length of " + this.type + " must be specified, pls use TypeInfoFactory.getVarcharTypeInfo to new Column.");
            }
            case CHAR: {
                throw new IllegalArgumentException("The length of " + this.type + " must be specified, pls use TypeInfoFactory.getCharTypeInfo to new Column.");
            }
            default: {
                if (this.typeInfo != null) break;
                this.typeInfo = TypeInfoFactory.getPrimitiveTypeInfo(this.type);
            }
        }
    }

    private void initMapTypeInfo() {
        if (this.genericOdpsTypeList == null) {
            return;
        }
        if (this.genericOdpsTypeList.size() < 2) {
            throw new IllegalArgumentException("Error genericOdpsTypeList for Map.");
        }
        PrimitiveTypeInfo keyType = TypeInfoFactory.getPrimitiveTypeInfo(this.genericOdpsTypeList.get(0));
        PrimitiveTypeInfo valueType = TypeInfoFactory.getPrimitiveTypeInfo(this.genericOdpsTypeList.get(1));
        this.typeInfo = TypeInfoFactory.getMapTypeInfo(keyType, valueType);
    }

    private void initArrayTypeInfo() {
        if (this.genericOdpsTypeList == null) {
            return;
        }
        if (this.genericOdpsTypeList.size() < 1) {
            throw new IllegalArgumentException("Error genericOdpsTypeList for Array.");
        }
        PrimitiveTypeInfo valueType = TypeInfoFactory.getPrimitiveTypeInfo(this.genericOdpsTypeList.get(0));
        this.typeInfo = TypeInfoFactory.getArrayTypeInfo(valueType);
    }

    public String getName() {
        return this.name;
    }

    @Deprecated
    public OdpsType getType() {
        return this.type;
    }

    public TypeInfo getTypeInfo() {
        if (this.typeInfo == null) {
            throw new IllegalArgumentException("Failed to get TypeInfo for " + this.type.toString() + ", please set generic type list first.");
        }
        return this.typeInfo;
    }

    public String getComment() {
        return this.comment;
    }

    @Deprecated
    public Long getLabel() {
        if (this.label == null) {
            return null;
        }
        try {
            return Long.parseLong(this.label);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public List<String> getExtendedlabels() {
        return this.extendedLabels;
    }

    public String getCategoryLabel() {
        return this.label;
    }

    @Deprecated
    public List<OdpsType> getGenericTypeList() {
        return this.genericOdpsTypeList;
    }

    @Deprecated
    public void setGenericTypeList(List<OdpsType> genericOdpsTypeList) {
        this.genericOdpsTypeList = genericOdpsTypeList;
        this.initTypeInfo();
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        this.hasDefaultValue = defaultValue != null;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public void setNullable(boolean nullable) {
        this.isNullable = nullable;
    }

    public boolean hasDefaultValue() {
        return this.hasDefaultValue;
    }

    public GenerateExpression getGenerateExpression() {
        return this.generateExpression;
    }

    public void setGenerateExpression(GenerateExpression generateExpression) {
        this.generateExpression = generateExpression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Column column = (Column)o;
        return this.isNullable == column.isNullable && this.hasDefaultValue == column.hasDefaultValue && Objects.equals(this.name, column.name) && this.type == column.type && Objects.equals(this.typeInfo, column.typeInfo) && Objects.equals(this.comment, column.comment) && Objects.equals(this.label, column.label) && Objects.equals(this.defaultValue, column.defaultValue) && Objects.equals(this.genericOdpsTypeList, column.genericOdpsTypeList) && Objects.equals(this.extendedLabels, column.extendedLabels);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.typeInfo, this.comment, this.label, this.defaultValue, this.isNullable, this.hasDefaultValue, this.genericOdpsTypeList, this.extendedLabels);
    }

    public static class ColumnBuilder {
        private String name;
        private TypeInfo typeInfo;
        private String comment;
        private String label;
        private List<String> extendedLabels;
        private GenerateExpression generateExpression;
        private boolean notNull = false;

        private ColumnBuilder(String name, TypeInfo typeInfo) {
            this.name = name;
            this.typeInfo = typeInfo;
        }

        public ColumnBuilder withComment(String comment) {
            this.comment = comment;
            return this;
        }

        public ColumnBuilder withLabel(String label) {
            this.label = label;
            return this;
        }

        public ColumnBuilder withExtendedLabels(List<String> extendedLabels) {
            this.extendedLabels = extendedLabels;
            return this;
        }

        public ColumnBuilder notNull() {
            this.notNull = true;
            return this;
        }

        public ColumnBuilder withGenerateExpression(GenerateExpression expression) {
            this.generateExpression = expression;
            return this;
        }

        public Column build() {
            return new Column(this);
        }
    }
}

