/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.tunnel;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.ship.DShipCommand;
import com.aliyun.odps.utils.StringUtils;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.output.DefaultOutputWriter;
import com.aliyun.openservices.odps.console.tunnel.Config;
import java.io.File;
import java.io.PrintStream;
import java.util.List;

public class TunnelCommand
extends AbstractCommand {
    private static final String DSHIP_COMMAND = "tunnel";
    private static final String DSHIP_SUBCOMMAND_UPLOAD = "upload";
    private static final String DSHIP_SUBCOMMAND_DOWNLOAD = "download";
    private static final String DSHIP_OPTION_CHARSET = "-c";
    private static final String DSHIP_OPTION_DATETIME_FORMAT_PATTERN = "-dfp";
    private static final String DSHIP_OPTION_NULL_INDICATOR = "-ni";
    private static final String DSHIP_OPTION_FIELD_DELIMITER = "-fd";
    private static final String DSHIP_OPTION_RECORD_DELIMITER = "-rd";
    private static final String DSHIP_OPTION_DISCARD_BAD_RECORDS = "-dbr";

    public static void printUsage(PrintStream out) {
        out.println("Usage: upload <table>[ partition(<partition spec>)] from <path>");
        out.println("Usage: download <table>[ partition(<partition spec>)] to <path>");
    }

    public TunnelCommand(String commandText, ExecutionContext context) {
        super(commandText, context);
        System.err.println("Tunnel command is deprecated, please use dship command");
    }

    public TunnelCommand(String tableName, String filename, boolean isUp, String commandText, ExecutionContext context) {
        super(commandText, context);
        System.err.println("Tunnel command is deprecated, please use dship command");
    }

    public void run() throws OdpsException, ODPSConsoleException {
        System.err.println("Tunnel command is deprecated, please use dship command");
    }

    public static TunnelCommand parse(List<String> optionList, ExecutionContext sessionContext) {
        return null;
    }

    public static DShipCommand parse(String commandString, ExecutionContext sessionContext) throws ODPSConsoleException {
        String readCommandString = commandString;
        if (readCommandString.toUpperCase().matches("\\s*UPLOAD\\s+\\w[\\s\\S]*") || readCommandString.toUpperCase().matches("\\s*DOWNLOAD\\s+\\w[\\s\\S]*")) {
            readCommandString = readCommandString.replaceAll("\\s+", " ");
            boolean isUp = true;
            if (readCommandString.toUpperCase().matches("\\s*DOWNLOAD\\s+\\w[\\s\\S]*")) {
                readCommandString = readCommandString.substring("DOWNLOAD ".length()).trim();
                isUp = false;
            } else {
                readCommandString = readCommandString.substring("UPLOAD ".length()).trim();
            }
            String tableName = "";
            int index = readCommandString.indexOf("(");
            if (index > 0) {
                tableName = readCommandString.substring(0, index);
                if (tableName.toUpperCase().indexOf(" PARTITION") > 0) {
                    tableName = tableName.substring(0, tableName.toUpperCase().indexOf(" PARTITION"));
                }
            } else {
                tableName = readCommandString.indexOf(" ") > 0 ? readCommandString.substring(0, readCommandString.indexOf(" ")) : readCommandString;
            }
            readCommandString = readCommandString.substring(tableName.length()).trim();
            String partitions = "";
            if (readCommandString.toUpperCase().indexOf("PARTITION") == 0 && readCommandString.indexOf("(") > 0 && readCommandString.indexOf(")") > 0 && readCommandString.indexOf("(") < readCommandString.indexOf(")")) {
                partitions = readCommandString.substring(readCommandString.indexOf("("), readCommandString.indexOf(")") + 1);
                readCommandString = readCommandString.substring(readCommandString.indexOf(")") + 1).trim();
            }
            String filename = "";
            if (isUp && readCommandString.toUpperCase().startsWith("FROM ")) {
                filename = readCommandString.substring(readCommandString.indexOf(" "));
            } else if (!isUp && readCommandString.toUpperCase().startsWith("TO ")) {
                filename = readCommandString.substring(readCommandString.indexOf(" "));
            } else {
                throw new ODPSConsoleException("bad command. '" + readCommandString + "'");
            }
            filename = filename.trim();
            readCommandString = readCommandString.substring(readCommandString.indexOf(filename) + filename.length());
            if (!"".equals(readCommandString)) {
                throw new ODPSConsoleException("bad command. '" + readCommandString + "'");
            }
            partitions = partitions.replace("(", "").replace(")", "").trim();
            String dshipCommandText = TunnelCommand.transformIntoDshipCommand(tableName, partitions, filename, isUp);
            DefaultOutputWriter writer = sessionContext.getOutputWriter();
            writer.writeDebug("Replacing command: " + commandString);
            writer.writeDebug("with " + dshipCommandText);
            return new DShipCommand(dshipCommandText, sessionContext);
        }
        return null;
    }

    private static String transformIntoDshipCommand(String tableName, String partitionSpec, String filename, boolean isUpload) throws ODPSConsoleException {
        StringBuilder dshipCommandBuilder = new StringBuilder();
        dshipCommandBuilder.append(DSHIP_COMMAND);
        dshipCommandBuilder.append(" ");
        if (isUpload) {
            dshipCommandBuilder.append(DSHIP_SUBCOMMAND_UPLOAD);
        } else {
            dshipCommandBuilder.append(DSHIP_SUBCOMMAND_DOWNLOAD);
        }
        dshipCommandBuilder.append(" ");
        Config config = Config.getConfig();
        String charset = config.getCharset();
        String datetimeFormat = config.getDateFormat();
        Character colDelimiter = Character.valueOf(config.getColDelimiter());
        Character rowDelimiter = Character.valueOf(config.getRowDelimiter());
        String nullIndicator = config.getNullIndicator();
        dshipCommandBuilder.append(DSHIP_OPTION_CHARSET);
        dshipCommandBuilder.append(TunnelCommand.formatArgument(charset));
        dshipCommandBuilder.append(DSHIP_OPTION_DATETIME_FORMAT_PATTERN);
        dshipCommandBuilder.append(TunnelCommand.formatArgument(datetimeFormat));
        dshipCommandBuilder.append(DSHIP_OPTION_FIELD_DELIMITER);
        dshipCommandBuilder.append(TunnelCommand.formatArgument(colDelimiter));
        dshipCommandBuilder.append(DSHIP_OPTION_RECORD_DELIMITER);
        dshipCommandBuilder.append(TunnelCommand.formatArgument(rowDelimiter));
        dshipCommandBuilder.append(DSHIP_OPTION_NULL_INDICATOR);
        dshipCommandBuilder.append(TunnelCommand.formatArgument(nullIndicator));
        if (isUpload) {
            Boolean discardBadRecord = config.isBadDiscard();
            dshipCommandBuilder.append(DSHIP_OPTION_DISCARD_BAD_RECORDS);
            dshipCommandBuilder.append(TunnelCommand.formatArgument(discardBadRecord.toString()));
            Long maxSize = config.getMaxSize();
            File fileToUpload = new File(filename);
            if (fileToUpload.exists() && fileToUpload.length() > maxSize) {
                throw new ODPSConsoleException("file size exceed " + maxSize / 1024L / 1024L + "M");
            }
            if (!fileToUpload.exists()) {
                throw new ODPSConsoleException("file not found.");
            }
        }
        String tableAndPartition = tableName;
        if (!StringUtils.isNullOrEmpty((String)partitionSpec)) {
            tableAndPartition = tableAndPartition + "/" + partitionSpec;
        }
        if (isUpload) {
            dshipCommandBuilder.append(filename);
            dshipCommandBuilder.append(" ");
            dshipCommandBuilder.append(tableAndPartition);
        } else {
            dshipCommandBuilder.append(tableAndPartition);
            dshipCommandBuilder.append(" ");
            dshipCommandBuilder.append(filename);
        }
        return dshipCommandBuilder.toString();
    }

    private static String formatArgument(String argument) {
        return " '" + argument + "' ";
    }

    private static String formatArgument(Character argument) {
        return " '" + argument + "' ";
    }
}

