/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.xflow;

import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.XFlows;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import com.aliyun.openservices.odps.console.utils.OdpsConnectionFactory;
import com.aliyun.openservices.odps.console.utils.antlr.AntlrObject;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class DescXFlowInstanceCommand
extends AbstractCommand {
    public static final String[] HELP_TAGS = new String[]{"describe", "desc", "instance"};
    private static final Pattern PATTERN = Pattern.compile("\\s*(DESCRIBE|DESC)\\s+INSTANCE(\\s+(.*))?", 34);
    private final String id;
    private final String projectName;

    public static void printUsage(PrintStream stream) {
        stream.println("Usage: describe|desc instance <instanceID>");
    }

    private DescXFlowInstanceCommand(String id, String project, String cmd, ExecutionContext ctx) {
        super(cmd, ctx);
        this.id = id;
        this.projectName = project;
    }

    private static Options getOptions() {
        Options options = new Options();
        options.addOption("p", "project", true, "user spec project");
        return options;
    }

    private static CommandLine getCommandLine(String[] args) throws ODPSConsoleException {
        try {
            GnuParser parser = new GnuParser();
            return parser.parse(DescXFlowInstanceCommand.getOptions(), args);
        }
        catch (ParseException e) {
            throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help.  " + e.getMessage(), (Throwable)e);
        }
    }

    public static DescXFlowInstanceCommand parse(String cmd, ExecutionContext ctx) throws ODPSConsoleException {
        Matcher m = PATTERN.matcher(cmd);
        if (m.matches()) {
            Odps odps;
            XFlows xFlows;
            boolean isXFlowInstance;
            String input = m.group(3);
            if (input == null) {
                throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help.  need specify a Instance Id.");
            }
            String[] inputs = new AntlrObject(input).getTokenStringArray();
            CommandLine commandLine = DescXFlowInstanceCommand.getCommandLine(inputs);
            String projectName = null;
            if (commandLine.hasOption("p")) {
                projectName = commandLine.getOptionValue("p");
            }
            if (commandLine.getArgList().size() != 1) {
                throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help.  Invalid Instance Id.");
            }
            String instanceId = commandLine.getArgs()[0];
            if (projectName == null) {
                projectName = ctx.getProjectName();
            }
            if (isXFlowInstance = (xFlows = (odps = OdpsConnectionFactory.createOdps((ExecutionContext)ctx)).xFlows()).isXFlowInstance(odps.instances().get(projectName, instanceId))) {
                return new DescXFlowInstanceCommand(instanceId, projectName, cmd, ctx);
            }
            return null;
        }
        return null;
    }

    public void run() throws OdpsException, ODPSConsoleException {
        ExecutionContext ctx = this.getContext();
        Odps odps = OdpsConnectionFactory.createOdps((ExecutionContext)ctx);
        Instance xInstance = odps.instances().get(this.projectName, this.id);
        if (!xInstance.isTerminated()) {
            ctx.getOutputWriter().writeError("Warning:xflow instance " + this.id + "is still running.");
        }
        ctx.getOutputWriter().writeResult(String.format("%-60s%-40s", "ID", xInstance.getId()));
        ctx.getOutputWriter().writeResult(String.format("%-60s%-40s", "Owner", xInstance.getOwner()));
        ctx.getOutputWriter().writeResult(String.format("%-60s%-40s", "StartTime", ODPSConsoleUtils.formatDate((Date)xInstance.getStartTime())));
        if (xInstance.getEndTime() != null) {
            ctx.getOutputWriter().writeResult(String.format("%-60s%-40s", "EndTime", ODPSConsoleUtils.formatDate((Date)xInstance.getEndTime())));
        }
        ctx.getOutputWriter().writeResult(String.format("%-60s%-40s\n", "Status", xInstance.getStatus()));
        ArrayList<String[]> xflowResults = new ArrayList<String[]>();
        this.getSubInstanceDesc(odps, xInstance, xflowResults);
        if (!xflowResults.isEmpty()) {
            int[] columnPercent = new int[]{40, 10, 10, 10};
            String[] title = new String[]{"SubInstanceId", "TaskType", "TaskName", "TaskStatus"};
            ODPSConsoleUtils.formaterTableRow((String[])title, (int[])columnPercent, (int)ctx.getConsoleWidth());
            ODPSConsoleUtils.formaterTable(xflowResults, (int[])columnPercent, (int)ctx.getConsoleWidth());
        }
    }

    private void getSubInstanceDesc(Odps odps, Instance xInstance, List<String[]> subInstanceResult) throws OdpsException, ODPSConsoleException {
        for (XFlows.XResult result : odps.xFlows().getXResults(xInstance).values()) {
            if ("SubWorkflow".equalsIgnoreCase(result.getNodeType())) {
                this.getSubInstanceDesc(odps, odps.instances().get(result.getInstanceId()), subInstanceResult);
                continue;
            }
            if ("Local".equalsIgnoreCase(result.getNodeType())) continue;
            Instance subInstance = odps.instances().get(result.getInstanceId());
            Map statusMap = subInstance.getTaskStatus();
            for (Map.Entry entry : statusMap.entrySet()) {
                Instance.TaskStatus task = (Instance.TaskStatus)entry.getValue();
                String[] taskResult = new String[]{result.getInstanceId(), task.getType(), task.getName(), task.getStatus().toString()};
                subInstanceResult.add(taskResult);
            }
        }
    }
}

