/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.auth.credentials.utils;

import com.aliyun.auth.credentials.utils.RefreshCachedSupplier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class NonBlocking
implements RefreshCachedSupplier.PrefetchStrategy {
    private final AtomicBoolean currentlyRefreshing = new AtomicBoolean(false);
    private final ExecutorService executor = new ThreadPoolExecutor(0, 1, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1), Executors.defaultThreadFactory());

    @Override
    public void prefetch(Runnable valueUpdater) {
        if (this.currentlyRefreshing.compareAndSet(false, true)) {
            try {
                this.executor.submit(() -> {
                    try {
                        valueUpdater.run();
                    }
                    finally {
                        this.currentlyRefreshing.set(false);
                    }
                });
            }
            catch (RuntimeException e) {
                this.currentlyRefreshing.set(false);
                throw e;
            }
        }
    }

    @Override
    public void close() {
        this.executor.shutdown();
    }
}

