<?php

// 引入阿里云SDK
require_once __DIR__ . '/vendor/autoload.php';

use AlibabaCloud\Client\AlibabaCloud;
use AlibabaCloud\Client\Exception\ClientException;
use AlibabaCloud\Client\Exception\ServerException;
use AlibabaCloud\Sts\Sts;

// 禁用错误显示
ini_set('display_errors', '0');


$bucket = 'examplebucket'; // 替换为您的Bucket名称
$region_id = 'cn-hangzhou'; // 替换为您的Bucket所在地域
$host = 'http://examplebucket.oss-cn-hangzhou.aliyuncs.com'; // 替换为您的Bucket域名
$expire_time = 3600; // 过期时间，单位为秒
$upload_dir = 'user-dir'; // 上传文件的前缀

// 计算HMAC-SHA256
function hmacsha256($key, $data) {
    return hash_hmac('sha256', $data, $key, true);
}

// 处理获取POST签名的请求
if ($_SERVER['REQUEST_METHOD'] === 'GET' && $_SERVER['REQUEST_URI'] === '/get_post_signature_for_oss_upload') {

    AlibabaCloud::accessKeyClient(getenv('OSS_ACCESS_KEY_ID'), getenv('OSS_ACCESS_KEY_SECRET'))
        ->regionId('cn-hangzhou')
        ->asDefaultClient();
    // 创建STS请求。
    $request = Sts::v20150401()->assumeRole();
    // 发起STS请求并获取结果。
    // 将<YOUR_ROLE_SESSION_NAME>设置为自定义的会话名称，例如oss-role-session。
    // 将<YOUR_ROLE_ARN>替换为拥有上传文件到指定OSS Bucket权限的RAM角色的ARN。
    $result = $request
        ->withRoleSessionName('oss-role-session')
        ->withDurationSeconds(3600)
        ->withRoleArn(getenv('OSS_STS_ROLE_ARN'))
        ->request();
    // 获取STS请求结果中的凭证信息。
    $tokenData = $result->get('Credentials');
    // 构建返回的JSON数据。
    $tempAccessKeyId = $tokenData['AccessKeyId'];
    $tempAccessKeySecret = $tokenData['AccessKeySecret'];
    $securityToken = $tokenData['SecurityToken'];

    $now = time();
    $dtObj = gmdate('Ymd\THis\Z', $now);
    $dtObj1 = gmdate('Ymd', $now);
    $dtObjPlus3h = gmdate('Y-m-d\TH:i:s.u\Z', strtotime('+3 hours', $now));

    // 构建Policy
    $policy = [
        "expiration" => $dtObjPlus3h,
        "conditions" => [
            ["x-oss-signature-version" => "OSS4-HMAC-SHA256"],
            ["x-oss-credential" => "{$tempAccessKeyId}/{$dtObj1}/cn-hangzhou/oss/aliyun_v4_request"],
            ["x-oss-security-token" => $securityToken],
            ["x-oss-date" => $dtObj],
        ]
    ];

    $policyStr = json_encode($policy);

    // 构造待签名字符串
    $stringToSign = base64_encode($policyStr);

    // 计算SigningKey
    $dateKey = hmacsha256(('aliyun_v4' . $tempAccessKeySecret), $dtObj1);
    $dateRegionKey = hmacsha256($dateKey, 'cn-hangzhou');
    $dateRegionServiceKey = hmacsha256($dateRegionKey, 'oss');
    $signingKey = hmacsha256($dateRegionServiceKey, 'aliyun_v4_request');

    // 计算Signature
    $result = hmacsha256($signingKey, $stringToSign);
    $signature = bin2hex($result);

    // 返回签名数据
    $responseData = [
        'policy' => $stringToSign,
        'x_oss_signature_version' => "OSS4-HMAC-SHA256",
        'x_oss_credential' => "{$tempAccessKeyId}/{$dtObj1}/cn-hangzhou/oss/aliyun_v4_request",
        'x_oss_date' => $dtObj,
        'signature' => $signature,
        'host' => $host,
        'dir' => $upload_dir,
        'security_token' => $securityToken
    ];

    header('Content-Type: application/json');
    echo json_encode($responseData);
    exit;
}

// 首页路由
if ($_SERVER['REQUEST_METHOD'] === 'GET' && $_SERVER['REQUEST_URI'] === '/') {
    echo file_get_contents(__DIR__ . '/public/index.html');
    exit;
}

// 其他路由
http_response_code(404);
echo json_encode(['message' => 'Not Found']);
exit;
?>