import { Word, SID } from "@tingwujs/core";

export interface Sentence {
  sid: SID;
  words: Word[];
}

export const getSentenseByWords = (words: Word[]) => {
  const { length } = words;
  let holdSentenceId: SID | undefined;
  const sentenses: Sentence[] = [];

  for (let i = 0; i < length; i++) {
    const word = words[i];
    if (holdSentenceId !== word.sentenceId) {
      holdSentenceId = word.sentenceId;
      sentenses.push({
        sid: word.sentenceId,
        words: [],
      });
    }

    sentenses[sentenses.length - 1].words.push(word);
  }
  return sentenses;
};

export const getTextContentBySentence = (sentence: Sentence) => {
  return sentence.words.reduce((value, word) => {
    return value + word.text;
  }, "");
};

export const generateTempTranslateWords = (
  sentences: Sentence[],
  getTranslate: (sentence: Sentence) => string
): Word[] => {
  let id = 1;
  return sentences.map(sentence => {
    return {
      wid: `translate-${id++}`,
      beginTime: 0,
      endTime: 0,
      sentenceId: sentence.sid,
      text: getTranslate(sentence),
      tag: "",
    };
  });
};
