// 获取拆分的 Promise
export function getPromise<T>() {
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  let resolve = (_v: T) => {};
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  let rejected = (_e: unknown) => {};

  const promise = new Promise<T>((res, rej) => {
    resolve = res;
    rejected = rej;
  });

  return {
    promise,
    resolve,
    rejected,
  };
}

// 等待超时
export const waitTimeout = (time: number) => {
  return new Promise(resolve => {
    setTimeout(() => {
      resolve(true);
    }, time);
  });
};
