export const isMacOS = (() => {
  if (typeof navigator !== "undefined") return navigator.platform.includes("Mac");
  if (typeof process !== "undefined") return process.platform.includes("darwin");
  return false;
})();

export const isWindows = (() => {
  if (typeof navigator !== "undefined") {
    return /(win32|win64|windows|wince)/i.test(window.navigator.userAgent);
  }
  return false;
})();

export function detectAppEnv() {
  const isPre = location.origin.includes("dev.aliyun.com") || location.origin.includes("pre-");
  return isPre ? "pre" : "prod";
}

export const forTest = () => 1;
