import copy from "copy-to-clipboard";
import { message } from "@tingwujs/design";
import { getTextHtml, TextHtmlType } from "./getTextHtml";

export const copyImgData = async (
  obj: TextHtmlType[],
  tips: {
    fn: string;
    str: string;
  },
  onCopySuccess: Function | undefined
) => {
  const goData = getTextHtml(obj);
  copy(goData, { format: "text/html" });
  // @ts-ignore
  message[tips.fn](tips.str);
  onCopySuccess && onCopySuccess();
};
